/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployArtifactRequest;
import nl.jpoint.maven.vertx.request.DeployModuleRequest;
import nl.jpoint.maven.vertx.request.Request;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class DeployUtils {
    private final Log log;
    private final MavenProject project;

    public DeployUtils(Log log, MavenProject project) {
        this.log = log;
        this.project = project;
    }

    public List<Request> createDeploySiteList(DeployConfiguration activeConfiguration, String siteClassifier) throws MojoFailureException {
        ArrayList<Request> deployModuleRequests = new ArrayList<Request>();
        for (Dependency dependency : this.createDeployList(activeConfiguration, siteClassifier)) {
            deployModuleRequests.add(new DeployArtifactRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), activeConfiguration.getContext()));
        }
        return deployModuleRequests;
    }

    public List<Request> createDeployModuleList(DeployConfiguration activeConfiguration, String classifier, boolean doRestart) throws MojoFailureException {
        ArrayList<Request> deployModuleRequests = new ArrayList<Request>();
        for (Dependency dependency : this.createDeployList(activeConfiguration, classifier)) {
            deployModuleRequests.add(new DeployModuleRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), 4, doRestart));
        }
        return deployModuleRequests;
    }

    private List<Dependency> createDeployList(DeployConfiguration activeConfiguration, String classifier) throws MojoFailureException {
        ArrayList<Dependency> deployModuleDependencies = new ArrayList<Dependency>();
        List dependencies = this.project.getDependencies();
        Iterator it = dependencies.iterator();
        if (!activeConfiguration.isTestScope()) {
            while (it.hasNext()) {
                Dependency dependency = (Dependency)it.next();
                if (!"test".equals(dependency.getScope())) continue;
                this.log.info((CharSequence)("Excluding artifact " + dependency.getArtifactId() + " from scope " + dependency.getScope()));
                it.remove();
            }
        }
        for (Dependency dependency : dependencies) {
            if (dependency.getVersion().endsWith("-SNAPSHOT") && !activeConfiguration.isDeploySnapshots()) {
                throw new MojoFailureException("Target does not allow for snapshots to be deployed");
            }
            if (!classifier.equals(dependency.getClassifier()) || this.excluded(activeConfiguration, dependency)) continue;
            deployModuleDependencies.add(dependency);
        }
        return deployModuleDependencies;
    }

    private boolean excluded(DeployConfiguration activeConfiguration, Dependency dependency) {
        if (activeConfiguration.getExclusions() == null) {
            return false;
        }
        for (Exclusion exclusion : activeConfiguration.getExclusions()) {
            if (!exclusion.getArtifactId().equals(dependency.getArtifactId()) || !exclusion.getGroupId().equals(dependency.getGroupId())) continue;
            this.log.info((CharSequence)("Excluding dependency " + dependency.getArtifactId()));
            return true;
        }
        return false;
    }
}

