/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.utils.AwsDeployUtils;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import nl.jpoint.maven.vertx.utils.RequestExecutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="deploy")
class VertxDeployMojo
extends AbstractDeployMojo {
    VertxDeployMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setActiveDeployConfig();
        if (this.activeConfiguration.isAutoScaling() && this.activeConfiguration.isOpsworks()) {
            throw new MojoFailureException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has both OpsWorks and Autoscaling enabled");
        }
        DeployUtils utils = new DeployUtils(this.getLog(), this.project);
        List<Request> deployModuleRequests = utils.createDeployModuleList(this.activeConfiguration, "mod");
        List<Request> deployArtifactRequests = utils.createDeploySiteList(this.activeConfiguration, "site");
        List<Request> deployConfigRequests = utils.createDeployConfigList(this.activeConfiguration, "config");
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployModuleRequests.size() + "' modules"));
        this.getLog().info((CharSequence)"Executing deploy request, waiting for Vert.x to respond.... (this might take some time)");
        if (this.activeConfiguration.isAutoScaling()) {
            this.deployWithAutoScaling(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else if (this.activeConfiguration.isOpsworks()) {
            this.deployWithOpsWorks(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else {
            this.normalDeploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        }
    }

    private void deployWithAutoScaling(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        if (this.activeConfiguration.getAutoScalingGroupId() == null) {
            throw new MojoExecutionException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has no autoScalingGroupId set");
        }
        RequestExecutor executor = new RequestExecutor(this.getLog());
        List<Ec2Instance> instances = AwsDeployUtils.getInstancesForAutoScalingGroup(this.getLog(), this.activeConfiguration, this.settings);
        if (instances.isEmpty()) {
            throw new MojoFailureException("No inService instances found in group " + this.activeConfiguration.getAutoScalingGroupId() + ". Nothing to do here, move along");
        }
        for (Ec2Instance instance : instances) {
            DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(deployConfigRequests).withElb(this.activeConfiguration.withElb()).withInstanceId(instance.getInstanceId()).withAutoScalingGroup(this.activeConfiguration.getAutoScalingGroupId()).withRestart(this.activeConfiguration.doRestart()).build();
            this.getLog().debug((CharSequence)("Sending deploy request  -> " + deployRequest.toJson(true)));
            this.getLog().info((CharSequence)("Sending deploy request to host with public IP " + instance.getPublicIp()));
            executor.executeAwsDeployRequest(deployRequest, this.activeConfiguration.getAwsPrivateIp() ? instance.getPrivateIp() : instance.getPublicIp());
        }
    }

    private void deployWithOpsWorks(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        RequestExecutor executor = new RequestExecutor(this.getLog());
        if (this.activeConfiguration.getOpsWorksStackId() == null) {
            throw new MojoFailureException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has no opsWorksStackId set");
        }
        AwsDeployUtils.getHostsOpsWorks(this.getLog(), this.activeConfiguration, this.settings);
        DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(deployConfigRequests).withElb(this.activeConfiguration.withElb()).withRestart(this.activeConfiguration.doRestart()).build();
        for (String host : this.activeConfiguration.getHosts()) {
            executor.executeAwsDeployRequest(deployRequest, host);
        }
    }

    private void normalDeploy(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        RequestExecutor executor = new RequestExecutor(this.getLog());
        DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(deployConfigRequests).withElb(this.activeConfiguration.withElb()).withRestart(this.activeConfiguration.doRestart()).build();
        for (String host : this.activeConfiguration.getHosts()) {
            executor.executeDeployRequest(deployRequest, host);
        }
    }
}

