/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import nl.jpoint.maven.vertx.utils.AwsException;
import nl.jpoint.maven.vertx.utils.AwsUtil;
import nl.jpoint.maven.vertx.utils.AwsXpathUtil;
import org.apache.http.client.methods.HttpGet;
import org.apache.maven.plugin.logging.Log;

public class AwsAutoScalingUtil {
    private static final String AWS_AUTOSCALING_SERVICE = "autoscaling";
    private final String targetHost = "autoscaling.eu-west-1.amazonaws.com";
    private final AwsUtil awsUtil;
    protected final SimpleDateFormat compressedIso8601DateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public AwsAutoScalingUtil(String accessKey, String secretAccessKey) {
        this.awsUtil = new AwsUtil(accessKey, secretAccessKey);
        this.compressedIso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public List<String> listInstancesInGroup(String groupId, Log log) throws AwsException {
        String date = this.compressedIso8601DateFormat.format(new Date());
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, "autoscaling.eu-west-1.amazonaws.com");
        HashMap<String, String> requestParamerters = new HashMap<String, String>();
        requestParamerters.put("AutoScalingGroupNames.member.1", groupId);
        requestParamerters.put("MaxRecords", "20");
        requestParamerters.put("Version", "2011-01-01");
        requestParamerters.put("Action", "DescribeAutoScalingGroups");
        HttpGet awsGet = this.awsUtil.createSignedGet("autoscaling.eu-west-1.amazonaws.com", requestParamerters, signedHeaders, date, AWS_AUTOSCALING_SERVICE, "eu-west-1", "DescribeAutoScalingGroups");
        byte[] result = this.executeRequest(awsGet);
        return AwsXpathUtil.listInstancesInAutoscalingGroupResponse(result);
    }

    /*
     * Exception decompiling
     */
    private byte[] executeRequest(HttpGet awsGet) throws AwsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String> createDefaultSignedHeaders(String date, String targetHost) {
        HashMap<String, String> signedHeaders = new HashMap<String, String>();
        signedHeaders.put("X-Amz-Date", date);
        signedHeaders.put("Host", targetHost);
        return signedHeaders;
    }
}

