/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.utils.AutoScalingGroup;
import nl.jpoint.maven.vertx.utils.AwsAutoScalingUtil;
import nl.jpoint.maven.vertx.utils.AwsEc2Util;
import nl.jpoint.maven.vertx.utils.AwsElbUtil;
import nl.jpoint.maven.vertx.utils.AwsException;
import nl.jpoint.maven.vertx.utils.AwsOpsWorksUtil;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class AwsDeployUtils {
    private final AwsAutoScalingUtil awsAutoScalingUtil;
    private final AwsEc2Util awsEc2Util;
    private final AwsOpsWorksUtil opsWorksUtil;
    private final AwsElbUtil awsElbUtil;

    public AwsDeployUtils(String serverId, Settings settings) throws MojoFailureException {
        if (settings.getServer(serverId) == null) {
            throw new MojoFailureException("No server config for id : " + serverId);
        }
        Server server = settings.getServer(serverId);
        this.awsAutoScalingUtil = new AwsAutoScalingUtil(server.getUsername(), server.getPassword());
        this.awsEc2Util = new AwsEc2Util(server.getUsername(), server.getPassword());
        this.opsWorksUtil = new AwsOpsWorksUtil(server.getUsername(), server.getPassword());
        this.awsElbUtil = new AwsElbUtil(server.getUsername(), server.getPassword());
    }

    public List<Ec2Instance> getInstancesForAutoScalingGroup(Log log, DeployConfiguration activeConfiguration) throws MojoFailureException {
        log.info((CharSequence)("retrieving list of instanceId's for auto scaling group with id : " + activeConfiguration.getAutoScalingGroupId()));
        activeConfiguration.getHosts().clear();
        try {
            log.debug((CharSequence)"describing Autoscaling group");
            AutoScalingGroup autoScalingGroup = this.awsAutoScalingUtil.describeAutoScalingGroup(activeConfiguration.getAutoScalingGroupId(), log);
            log.debug((CharSequence)"describing instances in Autoscaling group");
            List<Ec2Instance> instances = this.awsEc2Util.describeInstances(autoScalingGroup.getInstances(), activeConfiguration.getTag(), log);
            log.debug((CharSequence)"describing elb status");
            return this.awsElbUtil.describeInstanceElbStatus(instances, autoScalingGroup.getElbs());
        }
        catch (AwsException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    public void getHostsOpsWorks(Log log, DeployConfiguration activeConfiguration) throws MojoFailureException {
        log.info((CharSequence)("retrieving list of hosts for stack with id : " + activeConfiguration.getOpsWorksStackId()));
        activeConfiguration.getHosts().clear();
        try {
            List<String> hosts = this.opsWorksUtil.ListStackInstances(activeConfiguration.getOpsWorksStackId(), activeConfiguration.getOpsWorksLayerId(), activeConfiguration.getAwsPrivateIp(), log);
            for (String opsHost : hosts) {
                log.info((CharSequence)("Adding host from opsworks response : " + opsHost));
                activeConfiguration.getHosts().add("http://" + opsHost + ":6789");
            }
        }
        catch (AwsException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

