/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.utils.AwsState;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class RequestExecutor {
    private final Log log;
    private final long timeout;

    public RequestExecutor(Log log) {
        this.log = log;
        this.timeout = System.currentTimeMillis() + 660000L;
        log.info((CharSequence)("Setting timeout to : " + new Date(this.timeout)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AwsState executeAwsRequest(final HttpPost postRequest, boolean ignoreFailure) throws MojoExecutionException, MojoFailureException {
        try (final CloseableHttpClient httpClient = HttpClients.createDefault();){
            String buildId;
            final AtomicInteger waitFor = new AtomicInteger(1);
            final AtomicInteger status = new AtomicInteger(0);
            Object object = null;
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    this.log.error((CharSequence)("DeployModuleCommand : Post response status -> " + response.getStatusLine().getReasonPhrase()));
                    throw new MojoExecutionException("Error deploying module. ");
                }
                buildId = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
            exec.scheduleAtFixedRate(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    HttpGet get = new HttpGet(postRequest.getURI().getScheme() + "://" + postRequest.getURI().getHost() + ":" + postRequest.getURI().getPort() + "/deploy/status/" + buildId);
                    try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
                        int code = response.getStatusLine().getStatusCode();
                        String state = response.getStatusLine().getReasonPhrase();
                        switch (code) {
                            case 200: {
                                RequestExecutor.this.log.info((CharSequence)"Deploy request finished executing");
                                status.set(200);
                                waitFor.decrementAndGet();
                                return;
                            }
                            case 500: {
                                if (status.get() == 200) return;
                                status.set(500);
                                RequestExecutor.this.log.error((CharSequence)"Deploy request failed");
                                waitFor.decrementAndGet();
                                return;
                            }
                            default: {
                                if (System.currentTimeMillis() > RequestExecutor.this.timeout) {
                                    if (status.get() != 200) {
                                        status.set(500);
                                    }
                                    RequestExecutor.this.log.error((CharSequence)"Timeout while waiting for deploy request.");
                                    waitFor.decrementAndGet();
                                }
                                RequestExecutor.this.log.info((CharSequence)("Waiting for deploy to finish. Current status : " + state));
                                return;
                            }
                        }
                    }
                    catch (IOException e) {
                        if (status.get() != 200) {
                            status.set(500);
                        }
                        waitFor.decrementAndGet();
                    }
                }
            }, 0L, 15L, TimeUnit.SECONDS);
            while (waitFor.intValue() > 0) {
                Thread.sleep(15000L);
            }
            this.log.info((CharSequence)"Shutting down executor");
            exec.shutdown();
            this.log.info((CharSequence)"awaiting termination of executor");
            exec.awaitTermination(30L, TimeUnit.SECONDS);
            if (status.get() != 200 && !ignoreFailure) {
                throw new MojoFailureException("Error deploying module.");
            }
            object = status.get() == 200 ? AwsState.INSERVICE : AwsState.UNKNOWN;
            return object;
        }
        catch (IOException e) {
            this.log.error((CharSequence)"IOException ", (Throwable)e);
            throw new MojoExecutionException("Error deploying module.", (Exception)e);
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)"InterruptedException ", (Throwable)e);
            throw new MojoExecutionException("Error deploying module.", (Exception)e);
        }
    }

    private AwsState executeRequest(HttpPost postRequest) throws MojoExecutionException {
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                RequestExecutor.this.log.info((CharSequence)"Waiting for deploy request to return...");
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);){
                exec.awaitTermination(10L, TimeUnit.MINUTES);
                exec.shutdown();
                this.log.info((CharSequence)("DeployModuleCommand : Post response status code -> " + response.getStatusLine().getStatusCode()));
                if (response.getStatusLine().getStatusCode() != 200) {
                    this.log.error((CharSequence)("DeployModuleCommand : Post response status -> " + response.getStatusLine().getReasonPhrase()));
                    throw new MojoExecutionException("Error deploying module. ");
                }
            }
            catch (IOException e) {
                this.log.error((CharSequence)"testDeployModuleCommand ", (Throwable)e);
                throw new MojoExecutionException("Error deploying module.", (Exception)e);
            }
            catch (InterruptedException e) {
                this.log.error((CharSequence)"Timeout while waiting for deploy request.");
                throw new MojoExecutionException("Timeout while waiting for deploy request.");
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)"testDeployModuleCommand ", (Throwable)e);
            throw new MojoExecutionException("Error deploying module.", (Exception)e);
        }
        finally {
            if (!exec.isShutdown()) {
                this.log.info((CharSequence)"Shutdown executor after error");
                exec.shutdown();
            }
        }
        return AwsState.INSERVICE;
    }

    public void executeSingleDeployRequest(DeployConfiguration activeConfiguration, Request request) throws MojoExecutionException {
        for (String host : activeConfiguration.getHosts()) {
            this.log.info((CharSequence)("Deploying to host : " + host));
            HttpPost post = new HttpPost(this.createDeployUri(host) + request.getEndpoint());
            ByteArrayInputStream bos = new ByteArrayInputStream(request.toJson().getBytes());
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent((InputStream)bos);
            entity.setContentLength((long)request.toJson().getBytes().length);
            post.setEntity((HttpEntity)entity);
            this.executeRequest(post);
        }
    }

    public AwsState executeAwsDeployRequest(DeployRequest deployRequest, String host, boolean ignoreFailure) throws MojoFailureException, MojoExecutionException {
        return this.executeRequest(deployRequest, host, true, ignoreFailure);
    }

    public void executeDeployRequest(DeployRequest deployRequest, String host) throws MojoFailureException, MojoExecutionException {
        this.executeRequest(deployRequest, host, false, false);
    }

    private AwsState executeRequest(DeployRequest deployRequest, String host, boolean withAws, boolean ignoreFailure) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)("Deploying to host : " + host));
        HttpPost post = new HttpPost(this.createDeployUri(host) + deployRequest.getEndpoint());
        ByteArrayInputStream bos = new ByteArrayInputStream(deployRequest.toJson(false).getBytes());
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent((InputStream)bos);
        entity.setContentLength((long)deployRequest.toJson(false).getBytes().length);
        post.setEntity((HttpEntity)entity);
        if (!withAws) {
            return this.executeRequest(post);
        }
        return this.executeAwsRequest(post, ignoreFailure);
    }

    private String createDeployUri(String host) {
        if (!host.startsWith("http://")) {
            host = "http://" + host;
        }
        if (!host.endsWith(":6789")) {
            host = host + ":6789";
        }
        return host;
    }
}

