/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import nl.jpoint.maven.vertx.utils.AwsException;
import nl.jpoint.maven.vertx.utils.AwsUtil;
import nl.jpoint.maven.vertx.utils.AwsXpathUtil;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import org.apache.http.client.methods.HttpGet;
import org.apache.maven.plugin.logging.Log;

public class AwsEc2Util {
    private static final String AWS_EC2_SERVICE = "ec2";
    private final String targetHost = "ec2.eu-west-1.amazonaws.com";
    private final AwsUtil awsUtil;
    protected final SimpleDateFormat compressedIso8601DateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public AwsEc2Util(String accessKey, String secretAccessKey) {
        this.awsUtil = new AwsUtil(accessKey, secretAccessKey);
        this.compressedIso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public List<Ec2Instance> describeInstances(List<String> instanceIds, String tag, Log log) throws AwsException {
        if (instanceIds == null || instanceIds.size() == 0) {
            return new ArrayList<Ec2Instance>();
        }
        String date = this.compressedIso8601DateFormat.format(new Date());
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, "ec2.eu-west-1.amazonaws.com");
        HashMap<String, String> requestParamerters = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            requestParamerters.put("InstanceId." + i, instanceIds.get(i));
        }
        requestParamerters.put("Version", "2014-10-01");
        requestParamerters.put("Action", "DescribeInstances");
        HttpGet awsGet = this.awsUtil.createSignedGet("ec2.eu-west-1.amazonaws.com", requestParamerters, signedHeaders, date, AWS_EC2_SERVICE, "eu-west-1", "DescribeInstances");
        byte[] result = this.executeRequest(awsGet);
        log.debug((CharSequence)("Describe instance result -> " + new String(result)));
        return AwsXpathUtil.describeInstances(result, tag, instanceIds);
    }

    /*
     * Exception decompiling
     */
    private byte[] executeRequest(HttpGet awsGet) throws AwsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String> createDefaultSignedHeaders(String date, String targetHost) {
        HashMap<String, String> signedHeaders = new HashMap<String, String>();
        signedHeaders.put("X-Amz-Date", date);
        signedHeaders.put("Host", targetHost);
        return signedHeaders;
    }
}

