/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import nl.jpoint.maven.vertx.utils.AwsState;

public class Ec2Instance {
    private final String instanceId;
    private final String publicIp;
    private final String privateIp;
    private AwsState state = AwsState.UNKNOWN;

    private Ec2Instance(String instanceId, String publicIp, String privateIp) {
        this.instanceId = instanceId;
        this.publicIp = publicIp;
        this.privateIp = privateIp;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public AwsState getState() {
        return this.state;
    }

    public void updateState(AwsState awsState) {
        if (this.state.ordinal() < awsState.ordinal()) {
            this.state = awsState;
        }
    }

    public static class Builder {
        private String instanceId;
        private String publicIp;
        private String privateIp;

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withPublicIp(String ip) {
            this.publicIp = ip;
            return this;
        }

        public Builder withPrivateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public Ec2Instance build() {
            return new Ec2Instance(this.instanceId, this.publicIp, this.privateIp);
        }
    }
}

