/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.Comparator;
import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.utils.AwsDeployUtils;
import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import nl.jpoint.maven.vertx.utils.RequestExecutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="deploy")
class VertxDeployMojo
extends AbstractDeployMojo {
    VertxDeployMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setActiveDeployConfig();
        if (this.activeConfiguration.isAutoScaling() && this.activeConfiguration.isOpsworks()) {
            throw new MojoFailureException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has both OpsWorks and Autoscaling enabled");
        }
        DeployUtils utils = new DeployUtils(this.getLog(), this.project);
        List<Request> deployModuleRequests = utils.createDeployModuleList(this.activeConfiguration, "mod");
        List<Request> deployArtifactRequests = utils.createDeploySiteList(this.activeConfiguration, "site");
        List<Request> deployConfigRequests = utils.createDeployConfigList(this.activeConfiguration, "config");
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployModuleRequests.size() + "' modules"));
        this.getLog().info((CharSequence)"Executing deploy request, waiting for Vert.x to respond.... (this might take some time)");
        if (this.activeConfiguration.isAutoScaling()) {
            this.deployWithAutoScaling(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else if (this.activeConfiguration.isOpsworks()) {
            this.deployWithOpsWorks(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else {
            this.normalDeploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        }
    }

    private void deployWithAutoScaling(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        if (this.activeConfiguration.getAutoScalingGroupId() == null) {
            throw new MojoExecutionException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has no autoScalingGroupId set");
        }
        if (this.credentialsId == null) {
            throw new MojoExecutionException("credentialsId is not set");
        }
        AwsDeployUtils awsDeployUtils = new AwsDeployUtils(this.credentialsId, this.settings);
        List<Ec2Instance> instances = awsDeployUtils.getInstancesForAutoScalingGroup(this.getLog(), this.activeConfiguration);
        instances.sort(new Comparator<Ec2Instance>(){

            @Override
            public int compare(Ec2Instance o1, Ec2Instance o2) {
                return o1.getState().ordinal() - o2.getState().ordinal();
            }
        });
        if (instances.isEmpty()) {
            throw new MojoFailureException("No inService instances found in group " + this.activeConfiguration.getAutoScalingGroupId() + ". Nothing to do here, move along");
        }
        for (Ec2Instance instance : instances) {
            RequestExecutor executor = new RequestExecutor(this.getLog(), this.requestTimeout);
            boolean awsGroupIsInService = this.isInService(instances);
            this.getLog().info((CharSequence)("Auto scaling group inService :  " + awsGroupIsInService));
            boolean ignoreFailure = this.ignoreFailure(awsGroupIsInService, instance, this.countInServiceInstances(instances));
            this.getLog().info((CharSequence)("Ignoring failure for instance " + instance.getInstanceId() + " : " + ignoreFailure));
            DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(this.activeConfiguration.isDeployConfig() ? deployConfigRequests : null).withElb(this.activeConfiguration.withElb()).withInstanceId(instance.getInstanceId()).withAutoScalingGroup(this.activeConfiguration.getAutoScalingGroupId()).withRestart(this.activeConfiguration.doRestart()).build();
            this.getLog().debug((CharSequence)("Sending deploy request  -> " + deployRequest.toJson(true)));
            this.getLog().info((CharSequence)("Sending deploy request to instance with id " + instance.getInstanceId() + " state " + instance.getState().name() + " and public IP " + instance.getPublicIp()));
            AwsState newState = executor.executeAwsDeployRequest(deployRequest, this.activeConfiguration.getAwsPrivateIp() ? instance.getPrivateIp() : instance.getPublicIp(), this.activeConfiguration.withElb(), ignoreFailure);
            this.getLog().info((CharSequence)("Updates state for instance " + instance.getInstanceId() + " to " + newState.name()));
            instance.updateState(newState);
        }
    }

    private int countInServiceInstances(List<Ec2Instance> instances) {
        int i = 0;
        for (Ec2Instance instance : instances) {
            if (!instance.getState().equals((Object)AwsState.INSERVICE)) continue;
            ++i;
        }
        return i;
    }

    private boolean ignoreFailure(boolean groupInService, Ec2Instance ec2Instance, int inServiceInstances) {
        return groupInService && ec2Instance.getState().equals((Object)AwsState.OUTOFSERVICE) && inServiceInstances > 1;
    }

    private boolean isInService(List<Ec2Instance> instances) {
        for (Ec2Instance instance : instances) {
            if (!instance.getState().equals((Object)AwsState.INSERVICE)) continue;
            return true;
        }
        return false;
    }

    private void deployWithOpsWorks(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        if (this.activeConfiguration.getOpsWorksStackId() == null) {
            throw new MojoFailureException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has no opsWorksStackId set");
        }
        if (this.credentialsId == null) {
            throw new MojoExecutionException("credentialsId is not set");
        }
        AwsDeployUtils awsDeployUtils = new AwsDeployUtils(this.credentialsId, this.settings);
        awsDeployUtils.getHostsOpsWorks(this.getLog(), this.activeConfiguration);
        DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(deployConfigRequests).withElb(this.activeConfiguration.withElb()).withRestart(this.activeConfiguration.doRestart()).build();
        for (String host : this.activeConfiguration.getHosts()) {
            RequestExecutor executor = new RequestExecutor(this.getLog(), this.requestTimeout);
            executor.executeAwsDeployRequest(deployRequest, host, this.activeConfiguration.withElb(), false);
        }
    }

    private void normalDeploy(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(this.activeConfiguration.isDeployConfig() ? deployConfigRequests : null).withElb(this.activeConfiguration.withElb()).withRestart(this.activeConfiguration.doRestart()).build();
        for (String host : this.activeConfiguration.getHosts()) {
            RequestExecutor executor = new RequestExecutor(this.getLog(), this.requestTimeout);
            executor.executeDeployRequest(deployRequest, host);
        }
    }
}

