/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import nl.jpoint.maven.vertx.utils.AwsException;
import nl.jpoint.maven.vertx.utils.AwsUtil;
import nl.jpoint.maven.vertx.utils.AwsXpathUtil;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import org.apache.http.client.methods.HttpPost;

public class AwsElbUtil {
    private static final String EQUALSSIGN = "=";
    private static final String AWS_ELB_SERVICE = "elasticloadbalancing";
    private static final String AWS_ACTION = "Action";
    private static final String SERVICE_VERSION = "2012-06-01";
    protected final SimpleDateFormat compressedIso8601DateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private final String region;
    private final AwsUtil awsUtil;

    public AwsElbUtil(String accessKey, String secretAccessKey) {
        this(new AwsUtil(accessKey, secretAccessKey));
    }

    public AwsElbUtil(AwsUtil awsUtil) {
        this.region = "eu-west-1";
        this.awsUtil = awsUtil;
        this.compressedIso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private byte[] executeGetInstanceState(String loadbalancer) throws AwsException {
        String targetHost = "elasticloadbalancing." + this.region + ".amazonaws.com";
        String date = this.compressedIso8601DateFormat.format(new Date());
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, targetHost);
        HttpPost awsPost = this.awsUtil.createSignedPost(targetHost, signedHeaders, date, "Action=DescribeInstanceHealth&LoadBalancerName=" + loadbalancer + "&" + "Version" + EQUALSSIGN + SERVICE_VERSION, AWS_ELB_SERVICE, this.region);
        return this.executeRequest(awsPost);
    }

    /*
     * Exception decompiling
     */
    private byte[] executeRequest(HttpPost awsPost) throws AwsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String> createDefaultSignedHeaders(String date, String targetHost) {
        HashMap<String, String> signedHeaders = new HashMap<String, String>();
        signedHeaders.put("X-Amz-Date", date);
        signedHeaders.put("Host", targetHost);
        return signedHeaders;
    }

    public List<Ec2Instance> describeInstanceElbStatus(List<Ec2Instance> instances, List<String> elbs) throws AwsException {
        for (String elb : elbs) {
            byte[] awsResult = this.executeGetInstanceState(elb);
            AwsXpathUtil.updateInstanceState(instances, awsResult);
        }
        return instances;
    }
}

