/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import nl.jpoint.maven.vertx.utils.AwsException;
import nl.jpoint.maven.vertx.utils.AwsUtil;
import org.apache.http.client.methods.HttpPost;
import org.apache.maven.plugin.logging.Log;

public class AwsOpsWorksUtil {
    private static final String AWS_OPSWORKS_SERVICE = "opsworks";
    private final String targetHost = "opsworks.us-east-1.amazonaws.com";
    private final AwsUtil awsUtil;
    protected final SimpleDateFormat compressedIso8601DateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public AwsOpsWorksUtil(String accessKey, String secretAccessKey) {
        this.awsUtil = new AwsUtil(accessKey, secretAccessKey);
        this.compressedIso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private String getElasticIp(String stackId, String instanceId) throws AwsException {
        String date = this.compressedIso8601DateFormat.format(new Date());
        StringBuilder payloadBuilder = new StringBuilder("{\"InstanceId\":\"" + instanceId + "\"}");
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, "opsworks.us-east-1.amazonaws.com");
        HttpPost awsPost = this.awsUtil.createSignedOpsWorksPost("opsworks.us-east-1.amazonaws.com", signedHeaders, date, payloadBuilder.toString(), AWS_OPSWORKS_SERVICE, "us-east-1", "DescribeElasticIps");
        byte[] result = this.executeRequest(awsPost);
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getFactory();
        JsonParser parser = null;
        try {
            JsonNode eips;
            parser = factory.createParser(result);
            JsonNode describeResult = (JsonNode)mapper.readValue(parser, JsonNode.class);
            if (describeResult != null && (eips = describeResult.get("ElasticIps")) != null) {
                Iterator it = eips.elements();
                while (it.hasNext()) {
                    JsonNode eip = (JsonNode)it.next();
                    if (!instanceId.equals(eip.get("InstanceId").textValue())) continue;
                    return eip.get("Ip").textValue();
                }
            }
        }
        catch (IOException e) {
            throw new AwsException(e);
        }
        return null;
    }

    public List<String> ListStackInstances(String stackId, String layerId, boolean usePrivateIp, Log log) throws AwsException {
        ArrayList<String> hosts = new ArrayList<String>();
        String date = this.compressedIso8601DateFormat.format(new Date());
        Map<String, String> signedHeaders = this.createDefaultSignedHeaders(date, "opsworks.us-east-1.amazonaws.com");
        HttpPost awsPost = this.awsUtil.createSignedOpsWorksPost("opsworks.us-east-1.amazonaws.com", signedHeaders, date, "{\"StackId\":\"" + stackId + "\"}", AWS_OPSWORKS_SERVICE, "us-east-1", "DescribeInstances");
        byte[] result = this.executeRequest(awsPost);
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            JsonNode instances;
            JsonParser parser = factory.createParser(result);
            JsonNode describeResult = (JsonNode)mapper.readValue(parser, JsonNode.class);
            if (describeResult != null && (instances = describeResult.get("Instances")) != null) {
                Iterator it = instances.elements();
                while (it.hasNext()) {
                    String host = null;
                    JsonNode instance = (JsonNode)it.next();
                    JsonNode layers = instance.get("LayerIds");
                    if (layerId != null && layerId.length() > 0 && !this.containesLayer(layerId, layers)) continue;
                    String status = instance.get("Status").textValue();
                    if (status.equals("online")) {
                        if (usePrivateIp) {
                            host = instance.get("PrivateIp").textValue();
                        } else {
                            if (instance.get("InstanceId") != null) {
                                host = this.getElasticIp(stackId, instance.get("InstanceId").textValue());
                            }
                            if (host == null && instance.get("PublicDns") != null) {
                                host = instance.get("PublicDns").textValue();
                            }
                        }
                        hosts.add(host);
                        continue;
                    }
                    log.warn((CharSequence)("skipping host" + instance.get("InstanceId") + " with status " + status));
                }
            }
        }
        catch (IOException e) {
            throw new AwsException(e);
        }
        return hosts;
    }

    private boolean containesLayer(String layerId, JsonNode layers) {
        Iterator it = layers.elements();
        while (it.hasNext()) {
            JsonNode next = (JsonNode)it.next();
            if (!next.asText().equals(layerId)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private byte[] executeRequest(HttpPost awsPost) throws AwsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, String> createDefaultSignedHeaders(String date, String targetHost) {
        HashMap<String, String> signedHeaders = new HashMap<String, String>();
        signedHeaders.put("X-Amz-Date", date);
        signedHeaders.put("Host", targetHost);
        return signedHeaders;
    }
}

