/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import java.util.List;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.utils.AutoScalingGroup;
import nl.jpoint.maven.vertx.utils.AwsAutoScalingUtil;
import nl.jpoint.maven.vertx.utils.AwsEc2Util;
import nl.jpoint.maven.vertx.utils.AwsElbUtil;
import nl.jpoint.maven.vertx.utils.AwsException;
import nl.jpoint.maven.vertx.utils.AwsOpsWorksUtil;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class AwsDeployUtils {
    private final AwsAutoScalingUtil awsAutoScalingUtil;
    private final AwsEc2Util awsEc2Util;
    private final AwsOpsWorksUtil opsWorksUtil;
    private final AwsElbUtil awsElbUtil;
    AmazonAutoScalingClient awsAsClient;

    public AwsDeployUtils(String serverId, Settings settings) throws MojoFailureException {
        if (settings.getServer(serverId) == null) {
            throw new MojoFailureException("No server config for id : " + serverId);
        }
        Server server = settings.getServer(serverId);
        this.awsAsClient = new AmazonAutoScalingClient((AWSCredentials)new BasicAWSCredentials(server.getUsername(), server.getPassword()));
        this.awsAsClient.setRegion(Region.getRegion((Regions)Regions.EU_WEST_1));
        this.awsAutoScalingUtil = new AwsAutoScalingUtil(server.getUsername(), server.getPassword());
        this.awsEc2Util = new AwsEc2Util(server.getUsername(), server.getPassword());
        this.opsWorksUtil = new AwsOpsWorksUtil(server.getUsername(), server.getPassword());
        this.awsElbUtil = new AwsElbUtil(server.getUsername(), server.getPassword());
    }

    public com.amazonaws.services.autoscaling.model.AutoScalingGroup getAutoscalingGroup(DeployConfiguration activeConfiguration) {
        DescribeAutoScalingGroupsResult result = this.awsAsClient.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{activeConfiguration.getAutoScalingGroupId()}));
        return !result.getAutoScalingGroups().isEmpty() ? (com.amazonaws.services.autoscaling.model.AutoScalingGroup)result.getAutoScalingGroups().get(0) : null;
    }

    public void suspendScheduledActions(Log log, DeployConfiguration activeConfiguration) {
        this.awsAsClient.suspendProcesses(new SuspendProcessesRequest().withScalingProcesses(new String[]{"ScheduledActions", "Terminate", "ReplaceUnhealthy"}).withAutoScalingGroupName(activeConfiguration.getAutoScalingGroupId()));
        log.info((CharSequence)"Suspended autoscaling processes.");
    }

    public void setMinimalCapacity(Log log, int cap, DeployConfiguration activeConfiguration) {
        log.info((CharSequence)("Set minimal capacity for group to " + cap));
        this.awsAsClient.updateAutoScalingGroup(new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(activeConfiguration.getAutoScalingGroupId()).withMinSize(Integer.valueOf(cap)));
    }

    public void resumeScheduledActions(Log log, DeployConfiguration activeConfiguration) {
        this.awsAsClient.resumeProcesses(new ResumeProcessesRequest().withScalingProcesses(new String[]{"ScheduledActions", "Terminate", "ReplaceUnhealthy"}).withAutoScalingGroupName(activeConfiguration.getAutoScalingGroupId()));
        log.info((CharSequence)"Resumed autoscaling processes.");
    }

    public List<Ec2Instance> getInstancesForAutoScalingGroup(Log log, DeployConfiguration activeConfiguration) throws MojoFailureException, MojoExecutionException {
        log.info((CharSequence)("retrieving list of instanceId's for auto scaling group with id : " + activeConfiguration.getAutoScalingGroupId()));
        activeConfiguration.getHosts().clear();
        try {
            log.debug((CharSequence)"describing Autoscaling group");
            AutoScalingGroup autoScalingGroup = this.awsAutoScalingUtil.describeAutoScalingGroup(activeConfiguration.getAutoScalingGroupId(), activeConfiguration.isIgnoreInStandby(), log);
            if (!autoScalingGroup.deployable() && !activeConfiguration.isIgnoreDeployState()) {
                throw new MojoExecutionException("Autoscaling group is not in a deployable state.");
            }
            log.debug((CharSequence)"describing instances in Autoscaling group");
            List<Ec2Instance> instances = this.awsEc2Util.describeInstances(autoScalingGroup.getInstances(), activeConfiguration.getTag(), log);
            log.debug((CharSequence)"describing elb status");
            return this.awsElbUtil.describeInstanceElbStatus(instances, autoScalingGroup.getElbs());
        }
        catch (AwsException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    public void getHostsOpsWorks(Log log, DeployConfiguration activeConfiguration) throws MojoFailureException {
        log.info((CharSequence)("retrieving list of hosts for stack with id : " + activeConfiguration.getOpsWorksStackId()));
        activeConfiguration.getHosts().clear();
        try {
            List<String> hosts = this.opsWorksUtil.ListStackInstances(activeConfiguration.getOpsWorksStackId(), activeConfiguration.getOpsWorksLayerId(), activeConfiguration.getAwsPrivateIp(), log);
            for (String opsHost : hosts) {
                log.info((CharSequence)("Adding host from opsworks response : " + opsHost));
                activeConfiguration.getHosts().add("http://" + opsHost + ":6789");
            }
        }
        catch (AwsException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

