/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import nl.jpoint.maven.vertx.utils.RequestExecutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="single-deploy")
public class VertxSingleDeployMojo
extends AbstractDeployMojo {
    @Parameter(property="deploy.remoteIp")
    private String remoteIp;
    @Parameter(property="deploy.stubbed", defaultValue="true")
    private Boolean stubbed;
    @Parameter(property="deploy.withConfig", defaultValue="false")
    private Boolean withConfig;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployConfiguration configuration = new DeployConfiguration();
        configuration.getHosts().add(this.remoteIp);
        configuration.setTestScope(this.stubbed);
        configuration.setWithConfig(this.withConfig);
        boolean doRestart = true;
        this.activeConfiguration = configuration;
        DeployUtils utils = new DeployUtils(this.getLog(), this.project);
        RequestExecutor executor = new RequestExecutor(this.getLog());
        List<Request> deployModuleRequests = utils.createDeployModuleList(this.activeConfiguration, "mod");
        List<Request> deployArtifactRequests = utils.createDeploySiteList(this.activeConfiguration, "site");
        List<Request> deployConfigRequests = utils.createDeployConfigList(this.activeConfiguration, "config");
        DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(this.activeConfiguration.isDeployConfig() ? deployConfigRequests : null).withRestart(doRestart).withElb(false).build();
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployModuleRequests.size() + "' modules"));
        this.getLog().info((CharSequence)"Executing deploy request, waiting for Vert.x to respond.... (this might take some time)");
        this.getLog().debug((CharSequence)("Sending request -> " + deployRequest.toJson(true)));
        executor.executeDeployRequest(deployRequest, this.remoteIp);
    }
}

