/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

abstract class AbstractDeployMojo
extends AbstractMojo {
    static final String SITE_CLASSIFIER = "site";
    static final String MODULE_CLASSIFIER = "mod";
    static final String CONFIG_TYPE = "config";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    Settings settings;
    @Parameter(required=true)
    private List<DeployConfiguration> deployConfigurations;
    @Parameter(defaultValue="default", property="deploy.activeTarget")
    private String activeTarget;
    @Parameter(defaultValue="10", property="deploy.requestTimeout")
    protected Integer requestTimeout;
    @Parameter(property="deploy.credentialsId")
    protected String credentialsId;
    @Parameter(defaultValue="6789")
    protected Integer port;
    @Parameter(defaultValue="eu-west-1")
    protected String region;
    DeployConfiguration activeConfiguration;

    AbstractDeployMojo() {
    }

    DeployConfiguration setActiveDeployConfig() throws MojoFailureException {
        if (this.deployConfigurations.size() == 1) {
            this.getLog().info((CharSequence)"Found exactly one deploy config to activate.");
            this.activeConfiguration = this.deployConfigurations.get(0);
        } else {
            for (DeployConfiguration config : this.deployConfigurations) {
                if (!this.activeTarget.equals(config.getTarget())) continue;
                this.activeConfiguration = config;
                break;
            }
        }
        if (this.activeConfiguration == null) {
            this.getLog().error((CharSequence)"No active deployConfig !");
            throw new MojoFailureException("No active deployConfig !, config should contain at least one config with scope default");
        }
        this.getLog().info((CharSequence)("Deploy config with target " + this.activeConfiguration.getTarget() + " activated"));
        return this.activeConfiguration;
    }

    public Server getServer() throws MojoFailureException {
        if (this.credentialsId == null || this.credentialsId.isEmpty()) {
            throw new MojoFailureException("No CredentialsId set.");
        }
        Server server = this.settings.getServer(this.credentialsId);
        if (server == null) {
            throw new MojoFailureException("No server for id : " + this.credentialsId);
        }
        return server;
    }
}

