/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.executor;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import nl.jpoint.maven.vertx.executor.RequestExecutor;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.utils.AwsState;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class DefaultRequestExecutor
extends RequestExecutor {
    public DefaultRequestExecutor(Log log, Integer requestTimeout, Integer port) {
        super(log, requestTimeout, port);
    }

    private AwsState executeRequest(final HttpPost postRequest) throws MojoExecutionException {
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(() -> this.log.info((CharSequence)"Waiting for deploy request to return..."), 5L, 5L, TimeUnit.SECONDS);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    postRequest.abort();
                }
            }, this.getTimeout());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);){
                exec.shutdown();
                this.log.info((CharSequence)("DeployModuleCommand : Post response status code -> " + response.getStatusLine().getStatusCode()));
                if (postRequest.isAborted()) {
                    this.log.error((CharSequence)"Timeout while waiting for deploy request, aborting request");
                    throw new MojoExecutionException("Timeout while waiting for deploy request, aborting request");
                }
                if (response.getStatusLine().getStatusCode() != 200) {
                    this.log.error((CharSequence)("DeployModuleCommand : Post response status -> " + response.getStatusLine().getReasonPhrase()));
                    throw new MojoExecutionException("Error deploying module. ");
                }
            }
            catch (IOException e) {
                this.log.error((CharSequence)"testDeployModuleCommand ", (Throwable)e);
                throw new MojoExecutionException("Error deploying module.", (Exception)e);
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)"testDeployModuleCommand ", (Throwable)e);
            throw new MojoExecutionException("Error deploying module.", (Exception)e);
        }
        finally {
            if (!exec.isShutdown()) {
                this.log.info((CharSequence)"Shutdown executor after error");
                exec.shutdown();
            }
        }
        return AwsState.INSERVICE;
    }

    @Override
    public AwsState executeRequest(DeployRequest deployRequest, String host, boolean ignoreFailure) throws MojoExecutionException, MojoFailureException {
        return this.executeRequest(this.createPost(deployRequest, host));
    }
}

