/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import nl.jpoint.maven.vertx.utils.AwsState;
import org.apache.maven.plugin.logging.Log;

public class Ec2Instance {
    private final String instanceId;
    private final String publicIp;
    private final String privateIp;
    private AwsState state = AwsState.UNKNOWN;

    private Ec2Instance(String instanceId, String publicIp, String privateIp) {
        this.instanceId = instanceId;
        this.publicIp = publicIp;
        this.privateIp = privateIp;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public AwsState getState() {
        return this.state;
    }

    public void updateState(AwsState awsState) {
        if (this.state.ordinal() < awsState.ordinal()) {
            this.state = awsState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReachable(boolean usePrivate, int port, Log log) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(usePrivate ? this.privateIp : this.publicIp, port), 5000);
            boolean bl = socket.isConnected();
            return bl;
        }
        catch (IOException e) {
            log.error((CharSequence)("Error while checking if instance " + this.instanceId + " is reachable"), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.error((CharSequence)("Error while closing connection to " + this.instanceId), (Throwable)e);
                }
            }
        }
    }

    public static class Builder {
        private String instanceId;
        private String publicIp;
        private String privateIp;

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withPublicIp(String ip) {
            this.publicIp = ip;
            return this;
        }

        public Builder withPrivateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public Ec2Instance build() {
            return new Ec2Instance(this.instanceId, this.publicIp, this.privateIp);
        }
    }
}

