/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.DefaultDeployService;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deploy-direct")
public class VertxDeployDirectMojo
extends AbstractDeployMojo {
    @Parameter(property="deploy.remoteIp", required=true)
    private String remoteIp;
    @Parameter(property="deploy.testScope", defaultValue="false")
    private Boolean scopeTest;
    @Parameter(property="deploy.withConfig", defaultValue="true")
    private Boolean withConfig;
    @Parameter(property="deploy.allowSnapshots", defaultValue="false")
    private Boolean allowSnapshots;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployUtils utils = new DeployUtils(this.getLog(), this.project);
        DeployConfiguration configuration = new DeployConfiguration();
        configuration.getHosts().add(this.remoteIp);
        configuration.setTestScope(this.scopeTest);
        configuration.setWithConfig(this.withConfig);
        configuration.setDeploySnapshots(this.allowSnapshots);
        configuration.getExclusions().addAll(utils.parseExclusions(this.exclusions));
        this.activeConfiguration = configuration;
        List<Request> deployModuleRequests = utils.createDeployModuleList(this.activeConfiguration);
        List<Request> deployArtifactRequests = utils.createDeploySiteList(this.activeConfiguration, "site");
        List<Request> deployConfigRequests = utils.createDeployConfigList(this.activeConfiguration, "config");
        DefaultDeployService service = new DefaultDeployService(this.activeConfiguration, this.port, this.requestTimeout, this.getLog());
        service.normalDeploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
    }
}

