/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.Collections;
import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.request.DeployArtifactRequest;
import nl.jpoint.maven.vertx.request.DeployConfigRequest;
import nl.jpoint.maven.vertx.request.DeployModuleRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.AutoScalingDeployService;
import nl.jpoint.maven.vertx.service.DefaultDeployService;
import nl.jpoint.maven.vertx.service.OpsWorksDeployService;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy-single", requiresDependencyResolution=ResolutionScope.RUNTIME)
class VertxDeploySingleMojo
extends AbstractDeployMojo {
    @Parameter(property="deploy.single.type", required=true)
    private String type;
    @Parameter(property="deploy.single.groupId", required=true)
    private String groupId;
    @Parameter(property="deploy.single.artifactId", required=true)
    private String artifactId;
    @Parameter(property="deploy.single.classifier", required=false)
    private String classifier;
    @Parameter(property="deploy.single.version", required=true)
    private String version;

    VertxDeploySingleMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployUtils utils = new DeployUtils(this.getLog(), this.project);
        this.setActiveDeployConfig();
        if (this.activeConfiguration.useAutoScaling() && this.activeConfiguration.useOpsWorks()) {
            throw new MojoFailureException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has both OpsWorks and Autoscaling enabled");
        }
        this.activeConfiguration.getExclusions().addAll(utils.parseExclusions(this.exclusions));
        List<Object> deployModuleRequests = "jar".equals(this.type) ? this.createModuleRequest() : Collections.emptyList();
        List<Object> deployArtifactRequests = "site".equals(this.type) ? this.createArtifactRequest() : Collections.emptyList();
        List<Object> deployConfigRequests = "config".equals(this.type) ? this.createConfigRequest() : Collections.emptyList();
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployModuleRequests.size() + "' modules"));
        this.getLog().info((CharSequence)"Executing deploy request, waiting for Vert.x to respond.... (this might take some time)");
        if (this.activeConfiguration.useAutoScaling()) {
            AutoScalingDeployService service = new AutoScalingDeployService(this.activeConfiguration, this.region, this.port, this.requestTimeout, this.getServer(), this.getLog());
            service.deployWithAutoScaling(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else if (this.activeConfiguration.useOpsWorks()) {
            OpsWorksDeployService service = new OpsWorksDeployService(this.activeConfiguration, this.region, this.port, this.requestTimeout, this.getServer(), this.getLog());
            service.deployWithOpsWorks(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else {
            DefaultDeployService service = new DefaultDeployService(this.activeConfiguration, this.port, this.requestTimeout, this.getLog());
            service.normalDeploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        }
    }

    private List<Request> createModuleRequest() {
        return Collections.singletonList(new DeployModuleRequest(this.groupId, this.artifactId, this.version, this.type, this.activeConfiguration.doRestart()));
    }

    private List<Request> createArtifactRequest() {
        return Collections.singletonList(new DeployArtifactRequest(this.groupId, this.artifactId, this.version, this.classifier, this.type));
    }

    private List<Request> createConfigRequest() {
        return Collections.singletonList(new DeployConfigRequest(this.groupId, this.artifactId, this.version, this.classifier, this.type));
    }
}

