/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils.deploy.strategy;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import java.util.List;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DefaultDeployStrategy;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStrategyType;
import nl.jpoint.maven.vertx.utils.deploy.strategy.GuaranteeMinimumStrategy;
import nl.jpoint.maven.vertx.utils.deploy.strategy.KeepCapacityStrategy;
import nl.jpoint.maven.vertx.utils.deploy.strategy.WhateverStrategy;

public class DeployStateStrategyFactory {
    public static boolean isDeployable(DeployConfiguration activeConfiguration, AutoScalingGroup autoScalingGroup, List<Ec2Instance> instances) {
        boolean canDeploy = false;
        switch (activeConfiguration.getDeployStrategy()) {
            case KEEP_CAPACITY: {
                canDeploy = new KeepCapacityStrategy().isDeployable(activeConfiguration, autoScalingGroup, instances);
                break;
            }
            case DEFAULT: {
                canDeploy = new DefaultDeployStrategy().isDeployable(activeConfiguration, autoScalingGroup, instances);
                break;
            }
            case GUARANTEE_MINIMUM: {
                canDeploy = new GuaranteeMinimumStrategy().isDeployable(activeConfiguration, autoScalingGroup, instances);
                break;
            }
            case WHATEVER: {
                canDeploy = new WhateverStrategy().isDeployable(activeConfiguration, autoScalingGroup, instances);
                break;
            }
        }
        return canDeploy;
    }

    public static boolean isDeployableOnError(DeployConfiguration activeConfiguration, AutoScalingGroup asGroup, List<Ec2Instance> instances) {
        return !DeployStrategyType.DEFAULT.equals((Object)activeConfiguration.getDeployStrategy()) && DeployStateStrategyFactory.isDeployable(activeConfiguration, asGroup, instances);
    }
}

