/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.executor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.utils.AwsState;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class RequestExecutor {
    protected final Log log;
    private final Integer port;
    private final long timeout;

    public RequestExecutor(Log log, Integer requestTimeout, Integer port) {
        this.log = log;
        this.port = port;
        this.timeout = System.currentTimeMillis() + 60000L * (long)requestTimeout.intValue();
        log.info((CharSequence)("Setting timeout to : " + new Date(this.timeout)));
    }

    protected HttpPost createPost(DeployRequest deployRequest, String host) {
        this.log.info((CharSequence)("Deploying to host : " + host));
        HttpPost post = new HttpPost(this.createDeployUri(host) + deployRequest.getEndpoint());
        ByteArrayInputStream bos = new ByteArrayInputStream(deployRequest.toJson(false).getBytes());
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent((InputStream)bos);
        entity.setContentLength((long)deployRequest.toJson(false).getBytes().length);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    private String createDeployUri(String host) {
        if (!host.startsWith("http://")) {
            host = "http://" + host;
        }
        if (!host.endsWith(Integer.toString(this.port))) {
            host = host + ":" + this.port;
        }
        return host;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    public abstract AwsState executeRequest(DeployRequest var1, String var2, boolean var3) throws MojoExecutionException, MojoFailureException;
}

