/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployArtifactRequest;
import nl.jpoint.maven.vertx.request.DeployConfigRequest;
import nl.jpoint.maven.vertx.request.DeployModuleRequest;
import nl.jpoint.maven.vertx.request.Request;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class DeployUtils {
    private final Log log;
    private final MavenProject project;

    public DeployUtils(Log log, MavenProject project) {
        this.log = log;
        this.project = project;
    }

    public List<Request> createDeploySiteList(DeployConfiguration activeConfiguration, String siteClassifier) throws MojoFailureException {
        return this.createDeployListByClassifier(activeConfiguration, siteClassifier).stream().map(dependency -> new DeployArtifactRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType())).collect(Collectors.toList());
    }

    public List<Request> createDeployModuleList(DeployConfiguration activeConfiguration) throws MojoFailureException {
        return this.createDeployListByType(activeConfiguration, "jar").stream().map(dependency -> new DeployModuleRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), 4, activeConfiguration.doRestart())).collect(Collectors.toList());
    }

    public List<Request> createDeployConfigList(DeployConfiguration activeConfiguration, String type) throws MojoFailureException {
        return this.createDeployListByType(activeConfiguration, type).stream().map(dependency -> new DeployConfigRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType())).collect(Collectors.toList());
    }

    public List<Exclusion> parseExclusions(String exclusions) {
        ArrayList<Exclusion> result = new ArrayList<Exclusion>();
        if (StringUtils.isBlank((String)exclusions)) {
            return result;
        }
        Pattern.compile(";").splitAsStream(exclusions).forEach(s -> {
            String[] mavenIds = Pattern.compile(":").split((CharSequence)s, 2);
            if (mavenIds.length == 2) {
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId(mavenIds[0]);
                exclusion.setArtifactId(mavenIds[1]);
                result.add(exclusion);
            }
        });
        return result;
    }

    private List<Dependency> createDeployListByClassifier(DeployConfiguration activeConfiguration, String classifier) throws MojoFailureException {
        ArrayList<Dependency> deployModuleDependencies = new ArrayList<Dependency>();
        List dependencies = this.project.getDependencies();
        Iterator<Dependency> it = dependencies.iterator();
        this.FilterTestArtifacts(activeConfiguration, it);
        for (Dependency dependency : dependencies) {
            if (dependency.getVersion().endsWith("-SNAPSHOT") && !activeConfiguration.isDeploySnapshots()) {
                throw new MojoFailureException("Target does not allow for snapshots to be deployed");
            }
            if (!classifier.equals(dependency.getClassifier()) || this.excluded(activeConfiguration, dependency)) continue;
            deployModuleDependencies.add(dependency);
        }
        return deployModuleDependencies;
    }

    private List<Dependency> createDeployListByType(DeployConfiguration activeConfiguration, String type) throws MojoFailureException {
        ArrayList<Dependency> deployModuleDependencies = new ArrayList<Dependency>();
        List dependencies = this.project.getDependencies();
        Iterator<Dependency> it = dependencies.iterator();
        this.FilterTestArtifacts(activeConfiguration, it);
        for (Dependency dependency : dependencies) {
            if (dependency.getVersion().endsWith("-SNAPSHOT") && !activeConfiguration.isDeploySnapshots()) {
                throw new MojoFailureException("Target does not allow for snapshots to be deployed");
            }
            if (!type.equals(dependency.getType()) || this.excluded(activeConfiguration, dependency)) continue;
            deployModuleDependencies.add(dependency);
        }
        return deployModuleDependencies;
    }

    private boolean excluded(DeployConfiguration activeConfiguration, Dependency dependency) {
        if (activeConfiguration.getExclusions() == null) {
            return false;
        }
        for (Exclusion exclusion : activeConfiguration.getExclusions()) {
            if (!exclusion.getArtifactId().equals(dependency.getArtifactId()) || !exclusion.getGroupId().equals(dependency.getGroupId())) continue;
            this.log.info((CharSequence)("Excluding dependency " + dependency.getArtifactId()));
            return true;
        }
        return false;
    }

    private void FilterTestArtifacts(DeployConfiguration activeConfiguration, Iterator<Dependency> it) {
        if (!activeConfiguration.isTestScope()) {
            while (it.hasNext()) {
                Dependency dependency = it.next();
                if (!"test".equals(dependency.getScope())) continue;
                this.log.info((CharSequence)("Excluding artifact " + dependency.getArtifactId() + " from scope " + dependency.getScope()));
                it.remove();
            }
        }
    }
}

