/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.ArrayList;
import java.util.List;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStrategyType;
import org.apache.maven.model.Exclusion;

public class DeployConfiguration {
    private String target;
    private List<String> hosts = new ArrayList<String>();
    private boolean deployConfig = true;
    private List<Exclusion> exclusions = new ArrayList<Exclusion>();
    private boolean testScope = false;
    private boolean restart = false;
    private boolean deploySnapshots = false;
    private boolean awsPrivateIp = false;
    private boolean useOpsWorks = false;
    private boolean useAutoScaling = false;
    private boolean elb = false;
    private String autoScalingGroupId;
    private boolean ignoreInStandby = false;
    private boolean decrementDesiredCapacity = true;
    private DeployStrategyType deployStrategy = DeployStrategyType.KEEP_CAPACITY;
    private Integer maxCapacity = -1;
    private Integer minCapacity = 1;
    private String opsWorksLayerId = null;
    private String authToken;

    public String getAuthToken() {
        return this.authToken;
    }

    public String getAutoScalingGroupId() {
        return this.autoScalingGroupId;
    }

    public boolean useAutoScaling() {
        return this.useAutoScaling;
    }

    public boolean useOpsWorks() {
        return this.useOpsWorks;
    }

    public boolean isDeploySnapshots() {
        return this.deploySnapshots;
    }

    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public boolean isTestScope() {
        return this.testScope;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean useElbStatusCheck() {
        return this.elb;
    }

    public boolean doRestart() {
        return this.restart;
    }

    public boolean getAwsPrivateIp() {
        return this.awsPrivateIp;
    }

    public String getOpsWorksLayerId() {
        return this.opsWorksLayerId;
    }

    public void setTestScope(boolean testScope) {
        this.testScope = testScope;
    }

    public boolean isDeployConfig() {
        return this.deployConfig;
    }

    public void setWithConfig(Boolean withConfig) {
        this.deployConfig = withConfig;
    }

    public boolean isIgnoreInStandby() {
        return this.ignoreInStandby;
    }

    public boolean isDecrementDesiredCapacity() {
        return this.decrementDesiredCapacity;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public Integer getMinCapacity() {
        return this.minCapacity;
    }

    public DeployStrategyType getDeployStrategy() {
        return this.deployStrategy;
    }

    public void setDeployStrategy(DeployStrategyType deployStrategy) {
        this.deployStrategy = deployStrategy;
    }

    public DeployConfiguration withAutoScalingGroup(String autoScalingGroup) {
        this.autoScalingGroupId = autoScalingGroup;
        return this;
    }

    public DeployConfiguration withStrategy(String strategy) {
        this.deployStrategy = DeployStrategyType.valueOf(strategy);
        return this;
    }

    public DeployConfiguration withMaxGroupSize(Integer maxGroupSize) {
        this.maxCapacity = maxGroupSize;
        return this;
    }

    public DeployConfiguration withMinGroupSize(Integer minGroupSize) {
        this.minCapacity = minGroupSize;
        return this;
    }

    public DeployConfiguration withElb(boolean useElb) {
        this.elb = useElb;
        return this;
    }

    public DeployConfiguration withPrivateIp(boolean usePrivateIp) {
        this.awsPrivateIp = usePrivateIp;
        return this;
    }

    public DeployConfiguration withTestScope(boolean isTestScope) {
        this.testScope = isTestScope;
        return this;
    }

    public DeployConfiguration withConfig(boolean deployConfig) {
        this.deployConfig = deployConfig;
        return this;
    }

    public DeployConfiguration withRestart(boolean doRestart) {
        this.restart = doRestart;
        return this;
    }

    public DeployConfiguration withDecrementCapacity(boolean decrementCapacity) {
        this.decrementDesiredCapacity = decrementCapacity;
        return this;
    }

    public DeployConfiguration withIgnoreInStandby(boolean ignoreInStandby) {
        this.ignoreInStandby = ignoreInStandby;
        return this;
    }

    public DeployConfiguration withDeploySnapshots(boolean deploySnapshots) {
        this.deploySnapshots = deploySnapshots;
        return this;
    }

    public DeployConfiguration withExclusions(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public void setDeploySnapshots(boolean deploySnapshots) {
        this.deploySnapshots = deploySnapshots;
    }

    public DeployConfiguration withAuthToken(String authToken) {
        this.authToken = authToken;
        return this;
    }
}

