/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.service;

import java.util.List;
import nl.jpoint.maven.vertx.executor.DefaultRequestExecutor;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.DeployService;
import nl.jpoint.maven.vertx.utils.InstanceUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class DefaultDeployService
extends DeployService {
    private final DeployConfiguration activeConfiguration;
    private final Integer port;
    private final Integer requestTimeout;

    public DefaultDeployService(DeployConfiguration activeConfiguration, Integer port, Integer requestTimeout, Log log) {
        super(null, log);
        this.activeConfiguration = activeConfiguration;
        this.port = port;
        this.requestTimeout = requestTimeout;
    }

    public void normalDeploy(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(this.activeConfiguration.isDeployConfig() ? deployConfigRequests : null).withElb(this.activeConfiguration.useElbStatusCheck()).withRestart(this.activeConfiguration.doRestart()).build();
        DefaultRequestExecutor executor = new DefaultRequestExecutor(this.getLog(), this.requestTimeout, this.port, this.activeConfiguration.getAuthToken());
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployModuleRequests.size() + "' modules"));
        this.getLog().info((CharSequence)"Executing deploy request, waiting for Vert.x to respond.... (this might take some time)");
        this.getLog().debug((CharSequence)("Sending request -> " + deployRequest.toJson(true)));
        if (this.activeConfiguration.getHosts().stream().anyMatch(host -> !InstanceUtils.isReachable(host, this.port, this.getLog()))) {
            this.getLog().error((CharSequence)"Error connecting to deploy module on some instances");
            throw new MojoExecutionException("Error connecting to deploy module on some instances");
        }
        for (String host2 : this.activeConfiguration.getHosts()) {
            this.getLog().info((CharSequence)("Sending deploy request to host : " + host2));
            executor.executeRequest(deployRequest, host2, false);
        }
    }
}

