/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.service;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.Instance;
import java.util.List;
import java.util.stream.Collectors;
import nl.jpoint.maven.vertx.executor.AwsRequestExecutor;
import nl.jpoint.maven.vertx.executor.RequestExecutor;
import nl.jpoint.maven.vertx.executor.WaitForInstanceRequestExecutor;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.DeployService;
import nl.jpoint.maven.vertx.utils.AwsAutoScalingDeployUtils;
import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStateStrategyFactory;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStrategyType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;

public class AutoScalingDeployService
extends DeployService {
    private final DeployConfiguration activeConfiguration;
    private final String region;
    private final Integer port;
    private final Integer requestTimeout;

    public AutoScalingDeployService(DeployConfiguration activeConfiguration, String region, Integer port, Integer requestTimeout, Server server, Log log) throws MojoExecutionException {
        super(server, log);
        this.activeConfiguration = activeConfiguration;
        this.region = region;
        this.port = port;
        this.requestTimeout = requestTimeout;
    }

    public void deployWithAutoScaling(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        if (this.activeConfiguration.getAutoScalingGroupId() == null) {
            throw new MojoExecutionException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has no autoScalingGroupId set");
        }
        this.getLog().info((CharSequence)("Deploy with strategy : " + this.activeConfiguration.getDeployStrategy().name()));
        AwsAutoScalingDeployUtils awsDeployUtils = new AwsAutoScalingDeployUtils(this.getServer(), this.region, this.activeConfiguration);
        AutoScalingGroup asGroup = awsDeployUtils.getAutoScalingGroup();
        if (asGroup == null) {
            throw new MojoFailureException("Invalid auto-scaling group");
        }
        int originalDesiredCapacity = asGroup.getDesiredCapacity();
        List<Ec2Instance> instances = awsDeployUtils.getInstancesForAutoScalingGroup(this.getLog(), asGroup);
        if (instances.stream().anyMatch(i -> !i.isReachable(this.activeConfiguration.getAwsPrivateIp(), this.port, this.getLog()))) {
            this.getLog().error((CharSequence)"Error connecting to deploy module on some instances");
            throw new MojoExecutionException("Error connecting to deploy module on some instances");
        }
        if (this.activeConfiguration.useElbStatusCheck() && instances.stream().noneMatch(i -> i.getState() == AwsState.INSERVICE) || !this.activeConfiguration.useElbStatusCheck() && asGroup.getInstances().stream().noneMatch(i -> "InService".equals(i.getLifecycleState()))) {
            this.getLog().info((CharSequence)"No instances inService, using deploy strategy WHATEVER");
            this.activeConfiguration.setDeployStrategy(DeployStrategyType.WHATEVER);
        }
        if (DeployStrategyType.KEEP_CAPACITY.equals((Object)this.activeConfiguration.getDeployStrategy()) && awsDeployUtils.shouldAddExtraInstance(asGroup)) {
            this.getLog().info((CharSequence)"Adding extra instance");
            awsDeployUtils.setDesiredCapacity(this.getLog(), asGroup, asGroup.getDesiredCapacity() + 1);
            WaitForInstanceRequestExecutor waitForInstanceRequestExecutor = new WaitForInstanceRequestExecutor(this.getLog(), 10);
            waitForInstanceRequestExecutor.executeRequest(asGroup, awsDeployUtils);
            asGroup = awsDeployUtils.getAutoScalingGroup();
            instances = awsDeployUtils.getInstancesForAutoScalingGroup(this.getLog(), asGroup);
        }
        instances.sort((o1, o2) -> o1.getState().ordinal() - o2.getState().ordinal());
        if (instances.isEmpty()) {
            throw new MojoFailureException("No inService instances found in group " + this.activeConfiguration.getAutoScalingGroupId() + ". Nothing to do here, move along");
        }
        if (!DeployStateStrategyFactory.isDeployable(this.activeConfiguration, asGroup, instances)) {
            throw new MojoExecutionException("Auto scaling group is not in a deployable state.");
        }
        awsDeployUtils.suspendScheduledActions(this.getLog());
        instances = this.checkInstances(awsDeployUtils, asGroup, instances);
        Integer originalMinSize = asGroup.getMinSize();
        if (asGroup.getMinSize() >= asGroup.getDesiredCapacity()) {
            awsDeployUtils.setMinimalCapacity(this.getLog(), asGroup.getDesiredCapacity() <= 0 ? 0 : asGroup.getDesiredCapacity() - 1);
        }
        for (Ec2Instance instance : instances) {
            awsDeployUtils.updateInstanceState(instance, asGroup.getLoadBalancerNames());
            if (!DeployStateStrategyFactory.isDeployable(this.activeConfiguration, asGroup, instances)) {
                awsDeployUtils.resumeScheduledActions(this.getLog());
                throw new MojoExecutionException("auto scaling group is not in a deployable state.");
            }
            AwsRequestExecutor executor = new AwsRequestExecutor(this.getLog(), this.requestTimeout, this.port, this.activeConfiguration.getAuthToken());
            DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(this.activeConfiguration.isDeployConfig() ? deployConfigRequests : null).withElb(this.activeConfiguration.useElbStatusCheck()).withInstanceId(instance.getInstanceId()).withAutoScalingGroup(this.activeConfiguration.getAutoScalingGroupId()).withDecrementDesiredCapacity(this.activeConfiguration.isDecrementDesiredCapacity()).withRestart(this.activeConfiguration.doRestart()).build();
            this.getLog().debug((CharSequence)("Sending deploy request  -> " + deployRequest.toJson(true)));
            this.getLog().info((CharSequence)("Sending deploy request to instance with id " + instance.getInstanceId() + " state " + instance.getState().name() + " and public IP " + instance.getPublicIp()));
            try {
                AwsState newState = ((RequestExecutor)executor).executeRequest(deployRequest, this.activeConfiguration.getAwsPrivateIp() ? instance.getPrivateIp() : instance.getPublicIp(), !DeployStrategyType.DEFAULT.equals((Object)this.activeConfiguration.getDeployStrategy()));
                this.getLog().info((CharSequence)("Updates state for instance " + instance.getInstanceId() + " to " + newState.name()));
                instance.updateState(newState);
            }
            catch (MojoExecutionException | MojoFailureException e) {
                this.getLog().error((CharSequence)"Error during deploy. Resuming auto scaling processes.", e);
                awsDeployUtils.updateInstanceState(instance, asGroup.getLoadBalancerNames());
                if (DeployStateStrategyFactory.isDeployableOnError(this.activeConfiguration, asGroup, instances)) continue;
                awsDeployUtils.resumeScheduledActions(this.getLog());
                throw new MojoExecutionException("auto scaling group is not in a deployable state.");
            }
        }
        awsDeployUtils.setMinimalCapacity(this.getLog(), originalMinSize);
        if (DeployStrategyType.KEEP_CAPACITY.equals((Object)this.activeConfiguration.getDeployStrategy())) {
            awsDeployUtils.setDesiredCapacity(this.getLog(), asGroup, originalDesiredCapacity);
        }
        awsDeployUtils.resumeScheduledActions(this.getLog());
    }

    private List<Ec2Instance> checkInstances(AwsAutoScalingDeployUtils awsDeployUtils, AutoScalingGroup asGroup, List<Ec2Instance> instances) {
        List removedInstances = asGroup.getInstances().stream().filter(i -> i.getLifecycleState().equalsIgnoreCase(AwsState.STANDBY.name())).map(Instance::getInstanceId).filter(i -> awsDeployUtils.checkEc2Instance((String)i, this.getLog())).collect(Collectors.toList());
        if (removedInstances != null && removedInstances.size() > 0) {
            instances = instances.stream().filter(i -> !removedInstances.contains(i.getInstanceId())).collect(Collectors.toList());
        }
        return instances;
    }
}

