/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.AutoScalingDeployService;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy-single-as", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class VertxDeployAwsAsMojo
extends AbstractDeployMojo {
    @Parameter(required=true, property="deploy.as.id")
    private String autoScalingGroup;
    @Parameter(required=true, property="deploy.as.strategy")
    private String strategy;
    @Parameter(required=false, defaultValue="1", property="deploy.as.max")
    private Integer maxGroupSize;
    @Parameter(required=false, defaultValue="0", property="deploy.as.min")
    private Integer minGroupSize;
    @Parameter(required=false, defaultValue="false", property="deploy.as.elb")
    private boolean useElb;
    @Parameter(required=false, defaultValue="true", property="deploy.as.private")
    private boolean usePrivateIp;
    @Parameter(required=false, defaultValue="false", property="deploy.as.test")
    private boolean isTestScope;
    @Parameter(required=false, defaultValue="true", property="deploy.as.config")
    private boolean deployConfig;
    @Parameter(required=false, defaultValue="true", property="deploy.as.restart")
    private boolean doRestart;
    @Parameter(required=false, defaultValue="true", property="deploy.as.decrement")
    private boolean decrementCapacity;
    @Parameter(required=false, defaultValue="true", property="deploy.as.ignore")
    private boolean ignoreInStandby;
    @Parameter(required=false, defaultValue="false", property="deploy.as.allowSnapshots")
    private boolean deploySnapshots;
    @Parameter(required=false, defaultValue="", property="deploy.auth.token")
    private String authToken;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployUtils utils = new DeployUtils(this.getLog(), this.project);
        this.activeConfiguration = this.createConfiguration();
        this.activeConfiguration.getExclusions().addAll(utils.parseExclusions(this.exclusions));
        List<Request> deployModuleRequests = utils.createDeployApplicationList(this.activeConfiguration);
        List<Request> deployArtifactRequests = utils.createDeployArtifactList(this.activeConfiguration);
        List<Request> deployConfigRequests = utils.createDeployConfigList(this.activeConfiguration);
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployModuleRequests.size() + "' modules"));
        this.getLog().info((CharSequence)"Executing deploy request, waiting for Vert.x to respond.... (this might take some time)");
        AutoScalingDeployService service = new AutoScalingDeployService(this.activeConfiguration, this.region, this.port, this.requestTimeout, this.getServer(), this.getLog());
        service.deployWithAutoScaling(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
    }

    private DeployConfiguration createConfiguration() {
        return new DeployConfiguration().withAutoScalingGroup(this.autoScalingGroup).withStrategy(this.strategy).withMaxGroupSize(this.maxGroupSize).withMinGroupSize(this.minGroupSize).withElb(this.useElb).withPrivateIp(this.usePrivateIp).withTestScope(this.isTestScope).withConfig(this.deployConfig).withRestart(this.doRestart).withDecrementCapacity(this.decrementCapacity).withIgnoreInStandby(this.ignoreInStandby).withDeploySnapshots(this.deploySnapshots).withAuthToken(this.authToken);
    }
}

