/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils.deploy.strategy;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.LifecycleState;
import java.util.List;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.Ec2Instance;

public interface DeployStrategy {
    default public boolean isDeployable(DeployConfiguration activeConfiguration, AutoScalingGroup autoScalingGroup, List<Ec2Instance> instances) {
        long healthyInstances = autoScalingGroup.getInstances().stream().filter(i -> i.getLifecycleState().equals(LifecycleState.InService.toString())).count();
        long inStandbyInstances = autoScalingGroup.getInstances().stream().filter(i -> i.getLifecycleState().equals(LifecycleState.Standby.toString())).count();
        long inServiceInstances = instances.stream().filter(i -> AwsState.INSERVICE.equals((Object)i.getElbState())).count();
        return this.calculate(activeConfiguration, autoScalingGroup, inServiceInstances, healthyInstances, inStandbyInstances);
    }

    public boolean calculate(DeployConfiguration var1, AutoScalingGroup var2, long var3, long var5, long var7);
}

