/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.AutoScalingDeployService;
import nl.jpoint.maven.vertx.service.DefaultDeployService;
import nl.jpoint.maven.vertx.service.OpsWorksDeployService;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy", requiresDependencyResolution=ResolutionScope.RUNTIME)
class VertxDeployMojo
extends AbstractDeployMojo {
    VertxDeployMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setActiveDeployConfig();
        if (this.activeConfiguration.useAutoScaling() && this.activeConfiguration.useOpsWorks()) {
            throw new MojoFailureException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has both OpsWorks and Autoscaling enabled");
        }
        DeployUtils utils = new DeployUtils(this.getLog(), this.project);
        List<Request> deployModuleRequests = utils.createDeployApplicationList(this.activeConfiguration);
        List<Request> deployArtifactRequests = utils.createDeployArtifactList(this.activeConfiguration);
        List<Request> deployConfigRequests = utils.createDeployConfigList(this.activeConfiguration);
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployModuleRequests.size() + "' modules"));
        this.getLog().info((CharSequence)"Executing deploy request, waiting for Vert.x to respond.... (this might take some time)");
        if (this.activeConfiguration.useAutoScaling()) {
            AutoScalingDeployService service = new AutoScalingDeployService(this.activeConfiguration, this.region, this.port, this.requestTimeout, this.getServer(), this.getLog());
            service.deployWithAutoScaling(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else if (this.activeConfiguration.useOpsWorks()) {
            OpsWorksDeployService service = new OpsWorksDeployService(this.activeConfiguration, this.region, this.port, this.requestTimeout, this.getServer(), this.getLog());
            service.deployWithOpsWorks(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else {
            DefaultDeployService service = new DefaultDeployService(this.activeConfiguration, this.port, this.requestTimeout, this.getLog());
            service.normalDeploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        }
    }
}

