/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.service;

import java.util.List;
import nl.jpoint.maven.vertx.executor.AwsRequestExecutor;
import nl.jpoint.maven.vertx.executor.RequestExecutor;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.DeployService;
import nl.jpoint.maven.vertx.utils.AwsOpsWorksDeployUtils;
import nl.jpoint.maven.vertx.utils.InstanceUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;

public class OpsWorksDeployService
extends DeployService {
    private final DeployConfiguration activeConfiguration;
    private final String region;
    private final Integer port;
    private final Integer requestTimeout;

    public OpsWorksDeployService(DeployConfiguration activeConfiguration, String region, Integer port, Integer requestTimeout, Server server, Log log) {
        super(server, log);
        this.activeConfiguration = activeConfiguration;
        this.region = region;
        this.port = port;
        this.requestTimeout = requestTimeout;
    }

    public void deployWithOpsWorks(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        if (this.activeConfiguration.getOpsWorksLayerId() == null) {
            throw new MojoFailureException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has no opsWorksLayerId set");
        }
        AwsOpsWorksDeployUtils awsOpsWorksDeployUtils = new AwsOpsWorksDeployUtils(this.getServer(), this.region);
        awsOpsWorksDeployUtils.getHostsOpsWorks(this.getLog(), this.activeConfiguration);
        DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(deployConfigRequests).withElb(this.activeConfiguration.useElbStatusCheck()).withRestart(this.activeConfiguration.doRestart()).build();
        if (this.activeConfiguration.getHosts().stream().anyMatch(host -> !InstanceUtils.isReachable(host, this.port, this.getLog()))) {
            this.getLog().error((CharSequence)"Error connecting to deploy module on some instances");
            throw new MojoExecutionException("Error connecting to deploy module on some instances");
        }
        for (String host2 : this.activeConfiguration.getHosts()) {
            AwsRequestExecutor executor = new AwsRequestExecutor(this.getLog(), this.requestTimeout, this.port, this.activeConfiguration.getAuthToken());
            ((RequestExecutor)executor).executeRequest(deployRequest, host2, false);
        }
    }
}

