/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.utils.AwsAutoScalingDeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="as-enable")
public class AwsAsEnableMojo
extends AbstractDeployMojo {
    @Parameter(required=true, property="deploy.as.id")
    private String autoScalingGroupId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployConfiguration deployConfiguration = new DeployConfiguration().withAutoScalingGroup(this.autoScalingGroupId);
        AwsAutoScalingDeployUtils asUtils = new AwsAutoScalingDeployUtils(this.getServer(), this.region, deployConfiguration, this.getLog());
        AutoScalingGroup asGroup = asUtils.getAutoScalingGroup();
        if (asGroup.getInstances().size() == 0 && asGroup.getDesiredCapacity() == 0) {
            this.getLog().info((CharSequence)("Adding 1 instance to auto scaling group with id " + this.autoScalingGroupId));
            asUtils.enableAsGroup(this.autoScalingGroupId);
        }
    }
}

