/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DetachInstancesRequest;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.InstanceState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;

public class AwsAutoScalingDeployUtils {
    private static final String LATEST_REQUEST_TAG = "deploy:latest:version";
    private static final String SCOPE_TAG = "deploy:scope:tst";
    private static final String EXCLUSION_TAG = "deploy:exclusions";
    private static final String PROPERTIES_TAGS = "deploy:classifier:properties";
    private final AmazonAutoScalingClient awsAsClient;
    private final AmazonElasticLoadBalancingClient awsElbClient;
    private final AmazonEC2Client awsEc2Client;
    private final DeployConfiguration activeConfiguration;
    private final Log log;

    public AwsAutoScalingDeployUtils(Server server, String region, DeployConfiguration activeConfiguration, Log log) throws MojoFailureException {
        this.activeConfiguration = activeConfiguration;
        this.log = log;
        if (server == null) {
            throw new MojoFailureException("No server config provided");
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(server.getUsername(), server.getPassword());
        Region awsRegion = Region.getRegion((Regions)Regions.fromName((String)region));
        this.awsAsClient = new AmazonAutoScalingClient((AWSCredentials)credentials);
        this.awsAsClient.setRegion(awsRegion);
        this.awsElbClient = new AmazonElasticLoadBalancingClient((AWSCredentials)credentials);
        this.awsElbClient.setRegion(awsRegion);
        this.awsEc2Client = new AmazonEC2Client((AWSCredentials)credentials);
        this.awsEc2Client.setRegion(awsRegion);
        activeConfiguration.withAutoScalingGroup(this.matchAutoScalingGroupName(activeConfiguration.getAutoScalingGroupId()));
    }

    public AutoScalingGroup getAutoScalingGroup() {
        DescribeAutoScalingGroupsResult result = this.awsAsClient.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{this.activeConfiguration.getAutoScalingGroupId()}));
        return !result.getAutoScalingGroups().isEmpty() ? (AutoScalingGroup)result.getAutoScalingGroups().get(0) : null;
    }

    public void suspendScheduledActions() {
        this.awsAsClient.suspendProcesses(new SuspendProcessesRequest().withScalingProcesses(new String[]{"ScheduledActions", "Terminate", "ReplaceUnhealthy", "AZRebalance"}).withAutoScalingGroupName(this.activeConfiguration.getAutoScalingGroupId()));
        this.log.info((CharSequence)"Should a build fail the processes can be resumed using the AWS CLI.");
        this.log.info((CharSequence)("aws autoscaling resume-processes --auto-scaling-group-name " + this.activeConfiguration.getAutoScalingGroupId() + " --scaling-processes AZRebalance ReplaceUnhealthy Terminate ScheduledActions"));
        this.log.info((CharSequence)"Suspended auto scaling processes.");
    }

    public void setMinimalCapacity(int cap) {
        this.log.info((CharSequence)("Set minimal capacity for group to " + cap));
        this.awsAsClient.updateAutoScalingGroup(new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(this.activeConfiguration.getAutoScalingGroupId()).withMinSize(Integer.valueOf(cap)));
    }

    public void resumeScheduledActions() {
        this.awsAsClient.resumeProcesses(new ResumeProcessesRequest().withScalingProcesses(new String[]{"ScheduledActions", "Terminate", "ReplaceUnhealthy", "AZRebalance"}).withAutoScalingGroupName(this.activeConfiguration.getAutoScalingGroupId()));
        this.log.info((CharSequence)"Resumed auto scaling processes.");
    }

    public List<Ec2Instance> getInstancesForAutoScalingGroup(Log log, AutoScalingGroup autoScalingGroup) throws MojoFailureException, MojoExecutionException {
        log.info((CharSequence)("retrieving list of instanceId's for auto scaling group with id : " + this.activeConfiguration.getAutoScalingGroupId()));
        this.activeConfiguration.getHosts().clear();
        log.debug((CharSequence)"describing instances in auto scaling group");
        if (autoScalingGroup.getInstances().isEmpty()) {
            throw new MojoFailureException("No instances in AS group.");
        }
        Map instanceMap = autoScalingGroup.getInstances().stream().collect(Collectors.toMap(Instance::getInstanceId, Function.identity()));
        try {
            DescribeInstancesResult instancesResult = this.awsEc2Client.describeInstances(new DescribeInstancesRequest().withInstanceIds((Collection)autoScalingGroup.getInstances().stream().map(Instance::getInstanceId).collect(Collectors.toList())));
            List<Ec2Instance> ec2Instances = instancesResult.getReservations().stream().flatMap(r -> r.getInstances().stream()).map(this::toEc2Instance).collect(Collectors.toList());
            log.debug((CharSequence)"describing elb status");
            autoScalingGroup.getLoadBalancerNames().forEach(elb -> this.updateInstancesStateOnLoadBalancer((String)elb, ec2Instances));
            ec2Instances.stream().forEach(i -> i.updateAsState(AwsState.map(((Instance)instanceMap.get(i.getInstanceId())).getLifecycleState())));
            Collections.sort(ec2Instances, (o1, o2) -> {
                int sComp = o1.getAsState().compareTo(o2.getAsState());
                if (sComp != 0) {
                    return sComp;
                }
                return o1.getElbState().compareTo(o2.getElbState());
            });
            if (this.activeConfiguration.isIgnoreInStandby()) {
                return ec2Instances.stream().filter(i -> i.getAsState() != AwsState.STANDBY).collect(Collectors.toList());
            }
            return ec2Instances;
        }
        catch (AmazonClientException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    public boolean shouldAddExtraInstance(AutoScalingGroup autoScalingGroup) {
        return autoScalingGroup.getInstances().size() < autoScalingGroup.getMaxSize() && (this.activeConfiguration.getMaxCapacity() == -1 || autoScalingGroup.getInstances().size() <= this.activeConfiguration.getMaxCapacity());
    }

    private Ec2Instance toEc2Instance(com.amazonaws.services.ec2.model.Instance instance) {
        return new Ec2Instance.Builder().withInstanceId(instance.getInstanceId()).withPrivateIp(instance.getPrivateIpAddress()).withPublicIp(instance.getPublicIpAddress()).build();
    }

    public boolean setDesiredCapacity(AutoScalingGroup autoScalingGroup, Integer capacity) {
        this.log.info((CharSequence)("Setting desired capacity to : " + capacity));
        try {
            this.awsAsClient.setDesiredCapacity(new SetDesiredCapacityRequest().withAutoScalingGroupName(autoScalingGroup.getAutoScalingGroupName()).withDesiredCapacity(capacity).withHonorCooldown(Boolean.valueOf(false)));
            return true;
        }
        catch (AmazonClientException e) {
            this.log.error((CharSequence)e.getMessage());
            return false;
        }
    }

    private void updateInstancesStateOnLoadBalancer(String loadBalancerName, List<Ec2Instance> instances) {
        DescribeInstanceHealthResult result = this.awsElbClient.describeInstanceHealth(new DescribeInstanceHealthRequest(loadBalancerName));
        instances.stream().forEach(i -> result.getInstanceStates().stream().filter(s -> s.getInstanceId().equals(i.getInstanceId())).findFirst().ifPresent(s -> i.updateState(AwsState.map(s.getState()))));
    }

    public void updateInstanceState(Ec2Instance instance, List<String> loadBalancerNames) {
        for (String elb : loadBalancerNames) {
            DescribeInstanceHealthResult result = this.awsElbClient.describeInstanceHealth(new DescribeInstanceHealthRequest(elb));
            Optional<InstanceState> state = result.getInstanceStates().stream().filter(s -> s.getInstanceId().equals(instance.getInstanceId())).findFirst();
            if (!state.isPresent()) {
                instance.updateState(AwsState.UNKNOWN);
                continue;
            }
            instance.updateState(AwsState.valueOf(state.get().getState().toUpperCase()));
        }
    }

    public boolean checkInstanceInServiceOnAllElb(Instance newInstance, List<String> loadBalancerNames) {
        for (String elb : loadBalancerNames) {
            DescribeInstanceHealthResult result = this.awsElbClient.describeInstanceHealth(new DescribeInstanceHealthRequest(elb));
            Optional<InstanceState> state = result.getInstanceStates().stream().filter(s -> s.getInstanceId().equals(newInstance.getInstanceId())).findFirst();
            if (!state.isPresent()) {
                this.log.info((CharSequence)("instance state for instance " + newInstance.getInstanceId() + " on elb " + elb + " is unknown"));
                return false;
            }
            this.log.info((CharSequence)("instance state for instance " + newInstance.getInstanceId() + " on elb " + elb + " is " + state.get().getState()));
            if ("InService".equals(state.get().getState())) continue;
            return false;
        }
        return true;
    }

    public void enableAsGroup(String autoScalingGroupName) {
        this.awsAsClient.updateAutoScalingGroup(new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(autoScalingGroupName).withDesiredCapacity(Integer.valueOf(1)));
    }

    public boolean checkEc2Instance(String instanceId) {
        boolean instanceTerminated;
        block3: {
            instanceTerminated = false;
            try {
                DescribeInstancesResult result = this.awsEc2Client.describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId}));
                List instances = result.getReservations().stream().flatMap(r -> r.getInstances().stream()).filter(i -> i.getInstanceId().equals(instanceId)).collect(Collectors.toList());
                instanceTerminated = instances.isEmpty() || instances.stream().map(com.amazonaws.services.ec2.model.Instance::getState).filter(s -> s.getCode().equals(48)).findFirst().isPresent();
            }
            catch (AmazonServiceException e) {
                this.log.info((CharSequence)e.toString(), (Throwable)e);
                if (e.getStatusCode() != 400) break block3;
                instanceTerminated = true;
            }
        }
        if (instanceTerminated) {
            this.log.warn((CharSequence)("Invalid instance " + instanceId + " in group " + this.activeConfiguration.getAutoScalingGroupId() + ". Detaching instance."));
            this.awsAsClient.detachInstances(new DetachInstancesRequest().withAutoScalingGroupName(this.activeConfiguration.getAutoScalingGroupId()).withInstanceIds(new String[]{instanceId}).withShouldDecrementDesiredCapacity(Boolean.valueOf(false)));
        }
        return instanceTerminated;
    }

    public void setDeployMetadataTags(String version, Properties properties) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag().withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType("auto-scaling-group").withKey(LATEST_REQUEST_TAG).withValue(version).withResourceId(this.activeConfiguration.getAutoScalingGroupId()));
        tags.add(new Tag().withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType("auto-scaling-group").withKey(SCOPE_TAG).withValue(Boolean.toString(this.activeConfiguration.isTestScope())).withResourceId(this.activeConfiguration.getAutoScalingGroupId()));
        if (!this.activeConfiguration.getAutoScalingProperties().isEmpty()) {
            tags.add(new Tag().withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType("auto-scaling-group").withKey(PROPERTIES_TAGS).withValue(this.activeConfiguration.getAutoScalingProperties().stream().map(key -> key + ":" + this.getProperty((String)key, properties)).collect(Collectors.joining(";"))).withResourceId(this.activeConfiguration.getAutoScalingGroupId()));
        }
        if (!this.activeConfiguration.getExclusions().isEmpty()) {
            tags.add(new Tag().withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType("auto-scaling-group").withKey(EXCLUSION_TAG).withValue(this.activeConfiguration.getExclusions().stream().map(e -> e.getGroupId() + ":" + e.getGroupId()).collect(Collectors.joining(";"))).withResourceId(this.activeConfiguration.getAutoScalingGroupId()));
        }
        this.awsAsClient.createOrUpdateTags(new CreateOrUpdateTagsRequest().withTags(tags));
    }

    private String getProperty(String key, Properties properties) {
        return System.getProperty(key, properties.getProperty(key));
    }

    private String matchAutoScalingGroupName(String regex) {
        DescribeAutoScalingGroupsResult result = this.awsAsClient.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest());
        List<String> groups = this.toGroupNameList(result.getAutoScalingGroups());
        while (result.getNextToken() != null && !result.getNextToken().isEmpty()) {
            result = this.awsAsClient.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withNextToken(result.getNextToken()));
            groups.addAll(this.toGroupNameList(result.getAutoScalingGroups()));
        }
        List matchedGroups = groups.stream().filter(name -> name.matches(regex)).collect(Collectors.toList());
        if (matchedGroups == null || matchedGroups.isEmpty() || matchedGroups.size() != 1) {
            int matchSize;
            int n = matchSize = matchedGroups == null ? -1 : matchedGroups.size();
            if (matchSize > 0) {
                matchedGroups.stream().forEach(group -> this.log.error((CharSequence)("Matched group : " + group)));
            }
            throw new IllegalStateException("Unable to match group regex, matched group size " + matchSize);
        }
        return matchedGroups.stream().findFirst().orElse(regex);
    }

    private List<String> toGroupNameList(List<AutoScalingGroup> groups) {
        if (groups == null || groups.isEmpty()) {
            return new ArrayList<String>();
        }
        return groups.stream().map(AutoScalingGroup::getAutoScalingGroupName).collect(Collectors.toList());
    }
}

