/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.executor;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.Instance;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import nl.jpoint.maven.vertx.utils.AwsAutoScalingDeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class WaitForInstanceRequestExecutor {
    private final Log log;
    private final long timeout;
    private Instance newInstance = null;

    public WaitForInstanceRequestExecutor(Log log, Integer requestTimeout) {
        this.timeout = System.currentTimeMillis() + 60000L * (long)requestTimeout.intValue();
        this.log = log;
    }

    private Instance findNewInstance(AutoScalingGroup originalGroup, AutoScalingGroup updatedGroup) {
        updatedGroup.getInstances().removeAll(originalGroup.getInstances());
        return updatedGroup.getInstances().isEmpty() ? null : (Instance)updatedGroup.getInstances().get(0);
    }

    public boolean executeRequest(AutoScalingGroup autoScalingGroup, AwsAutoScalingDeployUtils awsDeployUtils) throws MojoExecutionException {
        AtomicInteger waitFor = new AtomicInteger(1);
        AtomicBoolean inService = new AtomicBoolean(false);
        this.log.info((CharSequence)"Waiting for new instance in asGroup to come in service...");
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(() -> {
            this.log.info((CharSequence)("existing instances : " + Arrays.toString(autoScalingGroup.getInstances().stream().map(Instance::getInstanceId).toArray())));
            AutoScalingGroup updatedGroup = awsDeployUtils.getAutoScalingGroup();
            this.log.info((CharSequence)("Updated instances : " + Arrays.toString(updatedGroup.getInstances().stream().map(Instance::getInstanceId).toArray())));
            if (updatedGroup.getInstances().equals(autoScalingGroup.getInstances())) {
                this.log.info((CharSequence)"no new instance found in auto scaling group.");
            }
            if (this.newInstance == null) {
                this.newInstance = this.findNewInstance(autoScalingGroup, updatedGroup);
                if (this.newInstance != null) {
                    this.log.info((CharSequence)("Found new instance with id " + this.newInstance.getInstanceId()));
                }
            }
            if (!autoScalingGroup.getLoadBalancerNames().isEmpty() && awsDeployUtils.checkInstanceInServiceOnAllElb(this.newInstance, autoScalingGroup.getLoadBalancerNames())) {
                waitFor.decrementAndGet();
            }
        }, 30L, 30L, TimeUnit.SECONDS);
        try {
            while (waitFor.intValue() > 0 && System.currentTimeMillis() <= this.timeout) {
                Thread.sleep(3000L);
            }
            this.log.info((CharSequence)"Shutting down executor");
            exec.shutdown();
            this.log.info((CharSequence)"awaiting termination of executor");
            exec.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)e.getMessage());
            inService.get();
        }
        catch (Throwable t) {
            this.log.error((CharSequence)"Throwable: ", t);
        }
        return inService.get();
    }
}

