/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.executor;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import nl.jpoint.maven.vertx.executor.RequestExecutor;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.LogUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class AwsRequestExecutor
extends RequestExecutor {
    public static final String ERROR_DEPLOYING_MODULE = "Error deploying module.";

    public AwsRequestExecutor(Log log, Integer requestTimeout, Integer port, String authToken) {
        super(log, requestTimeout, port, authToken);
    }

    @Override
    public AwsState executeRequest(DeployRequest deployRequest, String host, boolean ignoreFailure) throws MojoExecutionException, MojoFailureException {
        return this.executeAwsRequest(this.createPost(deployRequest, host), ignoreFailure);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AwsState executeAwsRequest(HttpPost postRequest, boolean ignoreFailure) throws MojoExecutionException, MojoFailureException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String buildId;
            AtomicInteger waitFor = new AtomicInteger(1);
            AtomicInteger status = new AtomicInteger(0);
            AtomicBoolean errorLogged = new AtomicBoolean(false);
            Throwable throwable = null;
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    this.log.error((CharSequence)("DeployModuleCommand : Post response status -> " + response.getStatusLine().getReasonPhrase()));
                    throw new MojoExecutionException("Error deploying module. ");
                }
                buildId = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
            exec.scheduleAtFixedRate(() -> {
                HttpGet get = new HttpGet(postRequest.getURI().getScheme() + "://" + postRequest.getURI().getHost() + ":" + postRequest.getURI().getPort() + "/deploy/status/" + buildId);
                try {
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
                    Throwable throwable = null;
                    try {
                        int code = response.getStatusLine().getStatusCode();
                        String state = response.getStatusLine().getReasonPhrase();
                        switch (code) {
                            case 200: {
                                this.log.info((CharSequence)"Deploy request finished executing");
                                LogUtil.logDeployResult(this.log, EntityUtils.toString((HttpEntity)response.getEntity()));
                                status.set(200);
                                waitFor.decrementAndGet();
                                return;
                            }
                            case 500: {
                                if (status.get() == 200) return;
                                status.set(500);
                                if (errorLogged.getAndSet(true)) return;
                                LogUtil.logDeployResult(this.log, EntityUtils.toString((HttpEntity)response.getEntity()));
                                waitFor.decrementAndGet();
                                return;
                            }
                            default: {
                                if (System.currentTimeMillis() > this.getTimeout()) {
                                    if (status.get() != 200) {
                                        status.set(500);
                                    }
                                    this.log.error((CharSequence)"Timeout while waiting for deploy request.");
                                    LogUtil.logDeployResult(this.log, EntityUtils.toString((HttpEntity)response.getEntity()));
                                    waitFor.decrementAndGet();
                                }
                                this.log.info((CharSequence)("Waiting for deploy to finish. Current status : " + state));
                                return;
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (response != null) {
                            AwsRequestExecutor.$closeResource(throwable, (AutoCloseable)response);
                        }
                    }
                }
                catch (IOException e) {
                    this.log.error((CharSequence)e.getMessage(), (Throwable)e);
                    if (status.get() != 200) {
                        status.set(500);
                    }
                    waitFor.decrementAndGet();
                }
            }, 0L, 2L, TimeUnit.SECONDS);
            while (waitFor.intValue() > 0) {
                Thread.sleep(3000L);
            }
            this.log.info((CharSequence)"Shutting down executor");
            exec.shutdown();
            this.log.info((CharSequence)"awaiting termination of executor");
            exec.awaitTermination(30L, TimeUnit.SECONDS);
            if (status.get() != 200 && !ignoreFailure) {
                throw new MojoFailureException(ERROR_DEPLOYING_MODULE);
            }
            AwsState awsState = status.get() == 200 ? AwsState.INSERVICE : AwsState.UNKNOWN;
            return awsState;
        }
        catch (IOException e) {
            this.log.error((CharSequence)"IOException ", (Throwable)e);
            throw new MojoExecutionException(ERROR_DEPLOYING_MODULE, (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error((CharSequence)"InterruptedException ", (Throwable)e);
            throw new MojoExecutionException(ERROR_DEPLOYING_MODULE, (Exception)e);
        }
    }
}

