/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.DefaultDeployService;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy-direct", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class VertxDeployDirectMojo
extends AbstractDeployMojo {
    @Parameter(property="deploy.remoteIp", required=true)
    private String remoteIp;
    @Parameter(property="deploy.testScope", defaultValue="false")
    private Boolean scopeTest;
    @Parameter(property="deploy.withConfig", defaultValue="true")
    private Boolean withConfig;
    @Parameter(property="deploy.allowSnapshots", defaultValue="false")
    private Boolean allowSnapshots;
    @Parameter(property="deploy.restart", defaultValue="false")
    private Boolean restart;
    @Parameter(required=false, defaultValue="", property="deploy.auth.token")
    private String authToken;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployUtils utils = new DeployUtils(this.getLog(), this.project, this.remoteRepos, this.repoSystem, this.repoSession);
        DeployConfiguration configuration = new DeployConfiguration();
        configuration.getHosts().add(this.remoteIp);
        configuration.setTestScope(this.scopeTest);
        configuration.setWithConfig(this.withConfig);
        configuration.setDeploySnapshots(this.allowSnapshots);
        configuration.withRestart(this.restart);
        configuration.getExclusions().addAll(utils.parseExclusions(this.exclusions));
        configuration.withAuthToken(this.authToken);
        configuration.withPort(this.port);
        this.activeConfiguration = configuration;
        List<Request> deployModuleRequests = utils.createDeployApplicationList(this.activeConfiguration);
        List<Request> deployArtifactRequests = utils.createDeployArtifactList(this.activeConfiguration);
        List<Request> deployConfigRequests = utils.createDeployConfigList(this.activeConfiguration);
        DefaultDeployService service = new DefaultDeployService(this.activeConfiguration, this.port, this.requestTimeout, this.getLog());
        service.normalDeploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
    }
}

