/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.AutoScalingDeployService;
import nl.jpoint.maven.vertx.service.DefaultDeployService;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy", requiresDependencyResolution=ResolutionScope.RUNTIME)
class VertxDeployMojo
extends AbstractDeployMojo {
    VertxDeployMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setActiveDeployConfig();
        DeployUtils utils = new DeployUtils(this.getLog(), this.remoteRepos, this.repoSystem, this.repoSession);
        List<Request> deployApplicationRequests = utils.createDeployApplicationList(this.applicationDependencies, this.activeConfiguration);
        List<Request> deployArtifactRequests = utils.createDeployArtifactList(this.artifactDependencies, this.activeConfiguration);
        List<Request> deployConfigRequests = utils.createDeployConfigList(this.configDependencies, this.activeConfiguration);
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployApplicationRequests.size() + "' modules"));
        this.getLog().info((CharSequence)"Executing deploy request, waiting for Vert.x to respond.... (this might take some time)");
        if (this.activeConfiguration.useAutoScaling()) {
            AutoScalingDeployService service = new AutoScalingDeployService(this.activeConfiguration, this.region, this.port, this.requestTimeout, this.getLog(), this.project.getProperties());
            service.deployWithAutoScaling(deployApplicationRequests, deployArtifactRequests, deployConfigRequests);
        } else {
            DefaultDeployService service = new DefaultDeployService(this.activeConfiguration, this.port, this.requestTimeout, this.getLog());
            service.normalDeploy(deployApplicationRequests, deployArtifactRequests, deployConfigRequests);
        }
    }
}

