/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.service.autoscaling;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import java.util.Comparator;
import java.util.List;
import nl.jpoint.maven.vertx.executor.WaitForInstanceRequestExecutor;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.service.autoscaling.AutoScalingPrePostHandler;
import nl.jpoint.maven.vertx.utils.AwsAutoScalingDeployUtils;
import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStateStrategyFactory;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStrategyType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class DefaultAutoScalingPrePostHandler
implements AutoScalingPrePostHandler {
    private final DeployConfiguration activeConfiguration;
    private final AwsAutoScalingDeployUtils awsDeployUtils;
    private final Log log;

    public DefaultAutoScalingPrePostHandler(DeployConfiguration activeConfiguration, AwsAutoScalingDeployUtils awsDeployUtils, Log log) {
        this.activeConfiguration = activeConfiguration;
        this.awsDeployUtils = awsDeployUtils;
        this.log = log;
    }

    @Override
    public void preDeploy(List<Ec2Instance> instances, AutoScalingGroup asGroup) throws MojoFailureException, MojoExecutionException {
        if (instances.isEmpty()) {
            throw new MojoFailureException("No instances in AS group." + (Object)((Object)this.activeConfiguration.getDeployStrategy()));
        }
        if (instances.stream().anyMatch(i -> !i.isReachable(this.activeConfiguration.getAwsPrivateIp(), this.activeConfiguration.getPort(), this.log))) {
            this.log.error((CharSequence)"Error connecting to deploy module on some instances");
            throw new MojoExecutionException("Error connecting to deploy module on some instances");
        }
        if (this.activeConfiguration.useElbStatusCheck() && instances.stream().noneMatch(i -> i.getElbState() == AwsState.INSERVICE) || !this.activeConfiguration.useElbStatusCheck() && asGroup.getInstances().stream().noneMatch(i -> "InService".equals(i.getLifecycleState()))) {
            this.activeConfiguration.setDeployStrategy(DeployStrategyType.WHATEVER);
            this.log.info((CharSequence)("No instances inService, using deploy strategy " + (Object)((Object)DeployStrategyType.WHATEVER)));
        }
        if (this.shouldSpinNewInstance(this.awsDeployUtils, asGroup)) {
            WaitForInstanceRequestExecutor.InstanceStatus instanceStatus = newInstance -> !asGroup.getLoadBalancerNames().isEmpty() && this.awsDeployUtils.checkInstanceInServiceOnAllElb(newInstance, asGroup.getLoadBalancerNames());
            this.awsDeployUtils.setDesiredCapacity(asGroup, asGroup.getDesiredCapacity() + 1);
            WaitForInstanceRequestExecutor waitForDeployedInstanceRequestExecutor = new WaitForInstanceRequestExecutor(this.log, 10);
            waitForDeployedInstanceRequestExecutor.executeRequest(asGroup, this.awsDeployUtils, instanceStatus);
            instances = this.awsDeployUtils.getInstancesForAutoScalingGroup(this.log, this.awsDeployUtils.getAutoScalingGroup());
        }
        instances.sort(Comparator.comparingInt(o -> o.getElbState().ordinal()));
        if (instances.isEmpty()) {
            throw new MojoFailureException("No inService instances found in group " + this.activeConfiguration.getAutoScalingGroupId() + ". Nothing to do here, move along");
        }
        if (!DeployStateStrategyFactory.isDeployable(this.activeConfiguration, asGroup, instances)) {
            throw new MojoExecutionException("Auto scaling group is not in a deployable state.");
        }
        if (this.activeConfiguration.isSticky()) {
            asGroup.getLoadBalancerNames().forEach(elbName -> this.awsDeployUtils.enableStickiness((String)elbName, this.activeConfiguration.getStickyPorts()));
        }
    }

    @Override
    public void postDeploy(AutoScalingGroup asGroup, Integer originalDesiredCapacity) {
        if (DeployStrategyType.KEEP_CAPACITY.equals((Object)this.activeConfiguration.getDeployStrategy())) {
            this.awsDeployUtils.setDesiredCapacity(asGroup, originalDesiredCapacity);
        }
        if (this.activeConfiguration.isSticky()) {
            asGroup.getLoadBalancerNames().forEach(elbName -> this.awsDeployUtils.disableStickiness((String)elbName, this.activeConfiguration.getStickyPorts()));
        }
    }

    @Override
    public void handleError(AutoScalingGroup asGroup) {
        if (this.activeConfiguration.isSticky()) {
            asGroup.getLoadBalancerNames().forEach(elbName -> this.awsDeployUtils.disableStickiness((String)elbName, this.activeConfiguration.getStickyPorts()));
        }
    }

    private boolean shouldSpinNewInstance(AwsAutoScalingDeployUtils awsDeployUtils, AutoScalingGroup asGroup) {
        return DeployStrategyType.KEEP_CAPACITY.equals((Object)this.activeConfiguration.getDeployStrategy()) && awsDeployUtils.shouldAddExtraInstance(asGroup);
    }
}

