/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.AmazonCloudWatchException;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import org.apache.maven.plugin.logging.Log;

public class AwsCloudWatchUtils {
    private static final String OK_DEPLOYS = "ok.deploys";
    private static final String FAILED_DEPLOYS = "failed.deploys";
    private static final String AS_GROUP_SIZE = "as.group.size";
    private final AmazonCloudWatch cloudWatch;
    private final int asGroupSize;
    private final DeployConfiguration activeConfiguration;
    private final Log log;
    private Long start = null;

    public AwsCloudWatchUtils(String region, int asGroupSize, DeployConfiguration activeConfiguration, Log log) {
        this.cloudWatch = (AmazonCloudWatch)((AmazonCloudWatchClientBuilder)AmazonCloudWatchClientBuilder.standard().withRegion(region)).build();
        this.asGroupSize = asGroupSize;
        this.activeConfiguration = activeConfiguration;
        this.log = log;
    }

    public void startTimer() {
        this.start = System.currentTimeMillis();
    }

    public void logSuccess() {
        this.logMetric(OK_DEPLOYS);
    }

    public void logFailed() {
        this.logMetric(FAILED_DEPLOYS);
    }

    private void logMetric(String metricName) {
        Dimension dimension1 = new Dimension().withName("Application").withValue(this.activeConfiguration.getMetricsConfiguration().getApplication());
        Dimension dimension2 = new Dimension().withName("Environments").withValue(this.activeConfiguration.getMetricsConfiguration().getEnvironment());
        ArrayList<MetricDatum> datums = new ArrayList<MetricDatum>();
        datums.add(new MetricDatum().withMetricName(AS_GROUP_SIZE).withUnit(StandardUnit.None).withValue(Double.valueOf(this.asGroupSize)).withDimensions(new Dimension[]{dimension1, dimension2}));
        datums.add(new MetricDatum().withMetricName(metricName).withUnit(StandardUnit.None).withValue(Double.valueOf(1.0)).withDimensions(new Dimension[]{dimension1, dimension2}));
        if (this.start != null) {
            datums.add(new MetricDatum().withMetricName("deploy.duration").withUnit(StandardUnit.Seconds).withValue(Double.valueOf(Duration.of(System.currentTimeMillis() - this.start, ChronoUnit.MILLIS).getSeconds())).withDimensions(new Dimension[]{dimension1, dimension2}));
        }
        try {
            this.cloudWatch.putMetricData(new PutMetricDataRequest().withNamespace(this.activeConfiguration.getMetricsConfiguration().getNamespace()).withMetricData(datums));
        }
        catch (AmazonCloudWatchException e) {
            this.log.error((CharSequence)"Unable to push Cloudwatch metrics.", (Throwable)e);
        }
    }
}

