/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.service;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.Instance;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import nl.jpoint.maven.vertx.executor.AwsRequestExecutor;
import nl.jpoint.maven.vertx.executor.RequestExecutor;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.DeployService;
import nl.jpoint.maven.vertx.service.autoscaling.AutoScalingPrePostFactory;
import nl.jpoint.maven.vertx.service.autoscaling.AutoScalingPrePostHandler;
import nl.jpoint.maven.vertx.utils.AwsAutoScalingDeployUtils;
import nl.jpoint.maven.vertx.utils.AwsCloudWatchUtils;
import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStateStrategyFactory;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStrategyType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class AutoScalingDeployService
extends DeployService {
    private final DeployConfiguration activeConfiguration;
    private final String region;
    private final Integer port;
    private final Integer requestTimeout;
    private final Properties properties;

    public AutoScalingDeployService(DeployConfiguration activeConfiguration, String region, Integer port, Integer requestTimeout, Log log, Properties properties) {
        super(log);
        this.activeConfiguration = activeConfiguration;
        this.region = region;
        this.port = port;
        this.requestTimeout = requestTimeout;
        this.properties = properties;
    }

    public void deployWithAutoScaling(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        if (this.activeConfiguration.getAutoScalingGroupId() == null) {
            throw new MojoExecutionException("ActiveConfiguration " + this.activeConfiguration.getTarget() + " has no autoScalingGroupId set");
        }
        this.getLog().info((CharSequence)("Deploy with strategy : " + this.activeConfiguration.getDeployStrategy().name()));
        AwsAutoScalingDeployUtils awsDeployUtils = new AwsAutoScalingDeployUtils(this.region, this.activeConfiguration, this.getLog());
        AutoScalingPrePostHandler prePostHandler = AutoScalingPrePostFactory.getPrePostHandler(this.activeConfiguration, awsDeployUtils, this.getLog());
        AutoScalingGroup asGroup = awsDeployUtils.getAutoScalingGroup();
        int originalDesiredCapacity = asGroup.getDesiredCapacity();
        List<Ec2Instance> instances = awsDeployUtils.getInstancesForAutoScalingGroup(this.getLog(), asGroup);
        prePostHandler.preDeploy(instances, asGroup);
        awsDeployUtils.suspendScheduledActions();
        instances = this.checkInstances(awsDeployUtils, asGroup, instances);
        Integer originalMinSize = asGroup.getMinSize();
        if (asGroup.getMinSize() >= asGroup.getDesiredCapacity()) {
            awsDeployUtils.setMinimalCapacity(asGroup.getDesiredCapacity() <= 0 ? 0 : asGroup.getDesiredCapacity() - 1);
        }
        AwsCloudWatchUtils metrics = new AwsCloudWatchUtils(this.region, instances.size(), this.activeConfiguration, this.getLog());
        metrics.startTimer();
        for (Ec2Instance instance : instances) {
            awsDeployUtils.updateInstanceState(instance, asGroup.getLoadBalancerNames());
            if (!DeployStateStrategyFactory.isDeployable(this.activeConfiguration, asGroup, instances)) {
                awsDeployUtils.resumeScheduledActions();
                prePostHandler.handleError(asGroup);
                throw new MojoExecutionException("auto scaling group is not in a deployable state.");
            }
            AwsRequestExecutor executor = new AwsRequestExecutor(this.getLog(), this.requestTimeout, this.port, this.activeConfiguration.getAuthToken());
            DeployRequest deployRequest = new DeployRequest.Builder().withModules(deployModuleRequests).withArtifacts(deployArtifactRequests).withConfigs(this.activeConfiguration.isDeployConfig() ? deployConfigRequests : null).withElb(this.activeConfiguration.useElbStatusCheck()).withAutoScalingGroup(this.activeConfiguration.getAutoScalingGroupId()).withDecrementDesiredCapacity(this.activeConfiguration.isDecrementDesiredCapacity()).withRestart(this.activeConfiguration.doRestart()).withTestScope(this.activeConfiguration.isTestScope()).build();
            this.getLog().debug((CharSequence)("Sending deploy request  -> " + deployRequest.toJson(true)));
            this.getLog().info((CharSequence)("Sending deploy request to instance with id " + instance.getInstanceId() + " state " + instance.getElbState().name() + " and public IP " + instance.getPublicIp()));
            try {
                AwsState newState = ((RequestExecutor)executor).executeRequest(deployRequest, this.activeConfiguration.getAwsPrivateIp() ? instance.getPrivateIp() : instance.getPublicIp(), this.activeConfiguration.getDeployStrategy() == DeployStrategyType.WHATEVER);
                this.getLog().info((CharSequence)("Updates state for instance " + instance.getInstanceId() + " to " + newState.name()));
                instance.updateState(newState);
                awsDeployUtils.setDeployMetadataTags(this.activeConfiguration.getProjectVersion(), this.properties);
            }
            catch (MojoExecutionException | MojoFailureException e) {
                this.getLog().error((CharSequence)"Error during deploy. Resuming auto scaling processes.", e);
                awsDeployUtils.updateInstanceState(instance, asGroup.getLoadBalancerNames());
                if (DeployStateStrategyFactory.isDeployableOnError(this.activeConfiguration, asGroup, instances)) continue;
                awsDeployUtils.resumeScheduledActions();
                prePostHandler.handleError(asGroup);
                metrics.logFailed();
                throw new MojoExecutionException("auto scaling group is not in a deployable state.");
            }
        }
        awsDeployUtils.setMinimalCapacity(originalMinSize);
        prePostHandler.postDeploy(asGroup, originalDesiredCapacity);
        awsDeployUtils.resumeScheduledActions();
        metrics.logSuccess();
    }

    private List<Ec2Instance> checkInstances(AwsAutoScalingDeployUtils awsDeployUtils, AutoScalingGroup asGroup, List<Ec2Instance> instances) {
        List removedInstances = asGroup.getInstances().stream().filter(i -> i.getLifecycleState().equalsIgnoreCase(AwsState.STANDBY.name())).map(Instance::getInstanceId).filter(awsDeployUtils::checkEc2Instance).collect(Collectors.toList());
        if (removedInstances != null && removedInstances.isEmpty()) {
            return instances.stream().filter(i -> !removedInstances.contains(i.getInstanceId())).collect(Collectors.toList());
        }
        return instances;
    }
}

