/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.service.autoscaling;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import java.util.List;
import nl.jpoint.maven.vertx.executor.WaitForInstanceRequestExecutor;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.service.autoscaling.AutoScalingPrePostHandler;
import nl.jpoint.maven.vertx.utils.AwsAutoScalingDeployUtils;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class SpinAndRemovePrePostHandler
implements AutoScalingPrePostHandler {
    private final DeployConfiguration activeConfiguration;
    private final AwsAutoScalingDeployUtils awsDeployUtils;
    private final Log log;

    public SpinAndRemovePrePostHandler(DeployConfiguration activeConfiguration, AwsAutoScalingDeployUtils awsDeployUtils, Log log) {
        this.activeConfiguration = activeConfiguration;
        this.awsDeployUtils = awsDeployUtils;
        this.log = log;
    }

    @Override
    public void preDeploy(List<Ec2Instance> instances, AutoScalingGroup asGroup) throws MojoFailureException, MojoExecutionException {
        if (asGroup.getInstances().isEmpty()) {
            this.log.info((CharSequence)"No instances found in autoscaling group, spinning new instance");
            WaitForInstanceRequestExecutor.InstanceStatus instanceStatus = newInstance -> this.awsDeployUtils.checkInstanceInService(newInstance.getInstanceId());
            this.awsDeployUtils.setDesiredCapacity(asGroup, asGroup.getDesiredCapacity() + 1);
            WaitForInstanceRequestExecutor waitForDeployedInstanceRequestExecutor = new WaitForInstanceRequestExecutor(this.log, 10);
            waitForDeployedInstanceRequestExecutor.executeRequest(asGroup, this.awsDeployUtils, instanceStatus);
            instances.addAll(this.awsDeployUtils.getInstancesForAutoScalingGroup(this.log, this.awsDeployUtils.getAutoScalingGroup()));
        }
    }

    @Override
    public void postDeploy(AutoScalingGroup asGroup, Integer originalDesiredCapacity) {
        if (this.activeConfiguration.spindown()) {
            this.log.info((CharSequence)("Setting desired capacity to : " + originalDesiredCapacity));
            this.awsDeployUtils.setDesiredCapacity(asGroup, originalDesiredCapacity);
        }
    }

    @Override
    public void handleError(AutoScalingGroup asGroup) {
    }
}

