/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import nl.jpoint.maven.vertx.request.DeployResult;
import org.apache.maven.plugin.logging.Log;

public final class LogUtil {
    private LogUtil() {
    }

    public static void logDeployResult(Log log, String result) {
        if (result == null || result.isEmpty()) {
            return;
        }
        try {
            DeployResult deployResult = (DeployResult)new ObjectMapper().readValue(result, DeployResult.class);
            log.info((CharSequence)"List of successfully deployed applications");
            deployResult.getSuccess().forEach(arg_0 -> ((Log)log).info(arg_0));
            if (!deployResult.getError().isEmpty()) {
                log.error((CharSequence)"List of applications that failed to deploy");
                deployResult.getError().forEach((key, entry) -> log.error((CharSequence)(key + " -> " + entry)));
            }
        }
        catch (IOException e) {
            log.error((CharSequence)e.getMessage(), (Throwable)e);
            log.warn((CharSequence)("Unable to parse deploy result -> " + result));
        }
    }
}

