/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.executor;

import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import nl.jpoint.maven.vertx.request.DeployRequest;
import nl.jpoint.maven.vertx.utils.AwsState;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class RequestExecutor {
    final Log log;
    private final Integer port;
    private final String authToken;
    private final long timeout;

    RequestExecutor(Log log, Integer requestTimeout, Integer port, String authToken) {
        this.log = log;
        this.port = port;
        this.authToken = authToken != null ? authToken : "";
        this.timeout = System.currentTimeMillis() + 60000L * (long)requestTimeout.intValue();
        log.info((CharSequence)("Setting timeout to : " + new Date(this.timeout)));
    }

    HttpPost createPost(DeployRequest deployRequest, String host) {
        this.log.info((CharSequence)("Deploying to host : " + host));
        HttpPost post = new HttpPost(this.createDeployUri(host) + deployRequest.getEndpoint());
        if (!StringUtils.isNullOrEmpty((String)this.authToken)) {
            this.log.info((CharSequence)"Adding authToken to request header.");
            post.addHeader("authToken", this.authToken);
        }
        ByteArrayInputStream bos = new ByteArrayInputStream(deployRequest.toJson(false).getBytes());
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent((InputStream)bos);
        entity.setContentLength((long)deployRequest.toJson(false).getBytes().length);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    private String createDeployUri(String host) {
        String mappedHost = null;
        if (!host.startsWith("http://")) {
            mappedHost = "http://" + host;
        }
        if (!host.endsWith(Integer.toString(this.port))) {
            mappedHost = host + ":" + this.port;
        }
        return mappedHost != null ? mappedHost : host;
    }

    long getTimeout() {
        return this.timeout;
    }

    public abstract AwsState executeRequest(DeployRequest var1, String var2, boolean var3) throws MojoExecutionException, MojoFailureException;
}

