/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.service.AutoScalingDeployService;
import nl.jpoint.maven.vertx.service.DefaultDeployService;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

abstract class AbstractDeployMojo
extends AbstractMojo {
    @Parameter(defaultValue="6789")
    Integer port;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteRepositories}", readonly=true, required=true)
    List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    Settings settings;
    @Parameter(defaultValue="10", property="deploy.requestTimeout")
    Integer requestTimeout;
    @Parameter(defaultValue="eu-west-1")
    String region;
    @Parameter(property="deploy.exclusions")
    String exclusions;
    private List<DeployConfiguration> deployConfigurations;
    @Parameter(defaultValue="default", property="deploy.activeTarget")
    private String activeTarget;
    @Parameter(property="deploy.credentialsId")
    private String credentialsId;
    @Parameter(required=false, defaultValue="", property="deploy.metrics.namespace")
    protected String metricNamespace;
    @Parameter(required=false, defaultValue="", property="deploy.metrics.application")
    protected String metricApplication;
    @Parameter(required=false, defaultValue="", property="deploy.metrics.environment")
    protected String metricEnvironment;
    DeployConfiguration activeConfiguration;

    AbstractDeployMojo() {
    }

    void setActiveDeployConfig() throws MojoFailureException {
        if (this.deployConfigurations.size() == 1) {
            this.getLog().info((CharSequence)"Found exactly one deploy config to activate.");
            this.activeConfiguration = this.deployConfigurations.get(0);
        } else {
            for (DeployConfiguration config : this.deployConfigurations) {
                if (!this.activeTarget.equals(config.getTarget())) continue;
                this.activeConfiguration = config;
                break;
            }
        }
        if (this.activeConfiguration == null) {
            this.getLog().error((CharSequence)"No active deployConfig !");
            throw new MojoFailureException("No active deployConfig !, config should contain at least one config with scope default");
        }
        this.getLog().info((CharSequence)("Deploy config with target " + this.activeConfiguration.getTarget() + " activated"));
        this.activeConfiguration.withProjectVersion(this.projectVersionAsString());
    }

    String projectVersionAsString() {
        return this.project.getGroupId() + ":" + this.project.getArtifactId() + ":pom:" + this.project.getVersion();
    }

    void deploy(List<Request> deployModuleRequests, List<Request> deployArtifactRequests, List<Request> deployConfigRequests) throws MojoFailureException, MojoExecutionException {
        if (this.activeConfiguration.useAutoScaling()) {
            AutoScalingDeployService service = new AutoScalingDeployService(this.activeConfiguration, this.region, this.port, this.requestTimeout, this.getLog(), this.project.getProperties());
            service.deploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        } else {
            DefaultDeployService service = new DefaultDeployService(this.activeConfiguration, this.port, this.requestTimeout, this.getLog());
            service.deploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
        }
    }
}

