/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.Collections;
import java.util.List;
import nl.jpoint.maven.vertx.mojo.AbstractDeployMojo;
import nl.jpoint.maven.vertx.request.DeployApplicationRequest;
import nl.jpoint.maven.vertx.request.DeployArtifactRequest;
import nl.jpoint.maven.vertx.request.DeployConfigRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.utils.DeployUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy-single", requiresDependencyResolution=ResolutionScope.RUNTIME)
class VertxDeploySingleMojo
extends AbstractDeployMojo {
    @Parameter(property="deploy.single.type", required=true)
    private String type;
    @Parameter(property="deploy.single.groupId", required=true)
    private String groupId;
    @Parameter(property="deploy.single.artifactId", required=true)
    private String artifactId;
    @Parameter(property="deploy.single.classifier")
    private String classifier;
    @Parameter(property="deploy.single.version", required=true)
    private String version;

    VertxDeploySingleMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeployUtils utils = new DeployUtils(this.getLog(), this.project, this.remoteRepos, this.repoSystem, this.repoSession);
        this.setActiveDeployConfig();
        this.activeConfiguration.getExclusions().addAll(utils.parseExclusions(this.exclusions));
        List<Object> deployModuleRequests = "jar".equals(this.type) ? this.createModuleRequest() : Collections.emptyList();
        List<Request> deployArtifactRequests = "zip".equals(this.type) || "tar.gz".equals(this.type) ? this.createArtifactRequest() : Collections.emptyList();
        List<Object> deployConfigRequests = "config".equals(this.type) ? this.createConfigRequest() : Collections.emptyList();
        this.getLog().info((CharSequence)("Constructed deploy request with '" + deployConfigRequests.size() + "' configs, '" + deployArtifactRequests.size() + "' artifacts and '" + deployModuleRequests.size() + "' modules"));
        this.deploy(deployModuleRequests, deployArtifactRequests, deployConfigRequests);
    }

    private List<Request> createModuleRequest() {
        return Collections.singletonList(new DeployApplicationRequest(this.groupId, this.artifactId, this.version, this.classifier, this.type, this.activeConfiguration.doRestart()));
    }

    private List<Request> createArtifactRequest() {
        return Collections.singletonList(new DeployArtifactRequest(this.groupId, this.artifactId, this.version, this.classifier, this.type));
    }

    private List<Request> createConfigRequest() {
        return Collections.singletonList(new DeployConfigRequest(this.groupId, this.artifactId, this.version, this.classifier, this.type));
    }
}

