/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClientBuilder;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DetachInstancesRequest;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClientBuilder;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.InstanceState;
import com.amazonaws.services.elasticloadbalancing.model.ListenerDescription;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.Ec2Instance;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class AwsAutoScalingDeployUtils {
    private static final String LATEST_REQUEST_TAG = "deploy:latest:version";
    private static final String SCOPE_TAG = "deploy:scope:tst";
    private static final String EXCLUSION_TAG = "deploy:exclusions";
    private static final String PROPERTIES_TAGS = "deploy:classifier:properties";
    private static final String DEPLOY_STICKINESS_POLICY = "deploy-stickiness-policy";
    private static final String AUTO_SCALING_GROUP = "auto-scaling-group";
    private final AmazonAutoScaling awsAsClient;
    private final AmazonElasticLoadBalancing awsElbClient;
    private final AmazonEC2 awsEc2Client;
    private final DeployConfiguration activeConfiguration;
    private final Log log;

    public AwsAutoScalingDeployUtils(String region, DeployConfiguration activeConfiguration, Log log) {
        this.activeConfiguration = activeConfiguration;
        this.log = log;
        this.awsAsClient = (AmazonAutoScaling)((AmazonAutoScalingClientBuilder)AmazonAutoScalingClientBuilder.standard().withRegion(region)).build();
        this.awsElbClient = (AmazonElasticLoadBalancing)((AmazonElasticLoadBalancingClientBuilder)AmazonElasticLoadBalancingClientBuilder.standard().withRegion(region)).build();
        this.awsEc2Client = (AmazonEC2)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withRegion(region)).build();
        activeConfiguration.withAutoScalingGroup(this.matchAutoScalingGroupName(activeConfiguration.getAutoScalingGroupId()));
    }

    public AutoScalingGroup getAutoScalingGroup() {
        DescribeAutoScalingGroupsResult result = this.awsAsClient.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{this.activeConfiguration.getAutoScalingGroupId()}));
        if (result.getAutoScalingGroups().isEmpty()) {
            this.log.error((CharSequence)("No Autoscaling group found with id : " + this.activeConfiguration.getAutoScalingGroupId()));
            throw new IllegalStateException();
        }
        return (AutoScalingGroup)result.getAutoScalingGroups().get(0);
    }

    public void suspendScheduledActions() {
        this.awsAsClient.suspendProcesses(new SuspendProcessesRequest().withScalingProcesses(new String[]{"ScheduledActions", "Terminate", "ReplaceUnhealthy", "AZRebalance", "AlarmNotification"}).withAutoScalingGroupName(this.activeConfiguration.getAutoScalingGroupId()));
        this.log.info((CharSequence)"Should a build fail the processes can be resumed using the AWS CLI.");
        this.log.info((CharSequence)("aws autoscaling resume-processes --auto-scaling-group-name " + this.activeConfiguration.getAutoScalingGroupId() + " --scaling-processes AZRebalance ReplaceUnhealthy Terminate ScheduledActions AlarmNotification"));
        this.log.info((CharSequence)"Suspended auto scaling processes.");
    }

    public void setMinimalCapacity(int cap) {
        this.log.info((CharSequence)("Set minimal capacity for group to " + cap));
        this.awsAsClient.updateAutoScalingGroup(new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(this.activeConfiguration.getAutoScalingGroupId()).withMinSize(Integer.valueOf(cap)));
    }

    public void resumeScheduledActions() {
        this.awsAsClient.resumeProcesses(new ResumeProcessesRequest().withScalingProcesses(new String[]{"ScheduledActions", "Terminate", "ReplaceUnhealthy", "AZRebalance", "AlarmNotification"}).withAutoScalingGroupName(this.activeConfiguration.getAutoScalingGroupId()));
        this.log.info((CharSequence)"Resumed auto scaling processes.");
    }

    public boolean checkInstanceInService(String instanceId) {
        DescribeInstancesResult instancesResult = this.awsEc2Client.describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId}));
        return instancesResult.getReservations().stream().flatMap(r -> r.getInstances().stream()).filter(instance -> instance.getInstanceId().equals(instanceId)).map(this::toEc2Instance).findFirst().map(ec2Instance -> ec2Instance.isReachable(this.activeConfiguration.getAwsPrivateIp(), this.activeConfiguration.getPort(), this.log)).orElse(false);
    }

    public List<Ec2Instance> getInstancesForAutoScalingGroup(Log log, AutoScalingGroup autoScalingGroup) throws MojoFailureException {
        log.info((CharSequence)("retrieving list of instanceId's for auto scaling group with id : " + this.activeConfiguration.getAutoScalingGroupId()));
        this.activeConfiguration.getHosts().clear();
        log.debug((CharSequence)"describing instances in auto scaling group");
        if (autoScalingGroup.getInstances().isEmpty()) {
            return new ArrayList<Ec2Instance>();
        }
        Map instanceMap = autoScalingGroup.getInstances().stream().collect(Collectors.toMap(Instance::getInstanceId, Function.identity()));
        try {
            DescribeInstancesResult instancesResult = this.awsEc2Client.describeInstances(new DescribeInstancesRequest().withInstanceIds((Collection)autoScalingGroup.getInstances().stream().map(Instance::getInstanceId).collect(Collectors.toList())));
            List<Ec2Instance> ec2Instances = instancesResult.getReservations().stream().flatMap(r -> r.getInstances().stream()).map(this::toEc2Instance).collect(Collectors.toList());
            log.debug((CharSequence)"describing elb status");
            autoScalingGroup.getLoadBalancerNames().forEach(elb -> this.updateInstancesStateOnLoadBalancer((String)elb, ec2Instances));
            ec2Instances.forEach(i -> i.updateAsState(AwsState.map(((Instance)instanceMap.get(i.getInstanceId())).getLifecycleState())));
            ec2Instances.sort((o1, o2) -> {
                int sComp = o1.getAsState().compareTo(o2.getAsState());
                if (sComp != 0) {
                    return sComp;
                }
                return o1.getElbState().compareTo(o2.getElbState());
            });
            if (this.activeConfiguration.isIgnoreInStandby()) {
                return ec2Instances.stream().filter(i -> i.getAsState() != AwsState.STANDBY).collect(Collectors.toList());
            }
            return ec2Instances;
        }
        catch (AmazonClientException e) {
            log.error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    public void enableStickiness(String loadbalancerName, List<Integer> ports) {
        this.awsElbClient.createLBCookieStickinessPolicy(new CreateLBCookieStickinessPolicyRequest().withPolicyName("deploy-stickiness-policy-" + loadbalancerName).withLoadBalancerName(loadbalancerName));
        this.describeMatchingElbListeners(loadbalancerName, ports).forEach(l -> this.enableStickinessOnListener(loadbalancerName, (ListenerDescription)l));
    }

    public void disableStickiness(String loadbalancerName, List<Integer> ports) {
        this.describeMatchingElbListeners(loadbalancerName, ports).forEach(l -> this.disableStickinessOnListener(loadbalancerName, (ListenerDescription)l));
        this.awsElbClient.deleteLoadBalancerPolicy(new DeleteLoadBalancerPolicyRequest().withLoadBalancerName(loadbalancerName).withPolicyName("deploy-stickiness-policy-" + loadbalancerName));
    }

    private List<ListenerDescription> describeMatchingElbListeners(String loadbalancerName, List<Integer> ports) {
        DescribeLoadBalancersResult loadbalancer = this.awsElbClient.describeLoadBalancers(new DescribeLoadBalancersRequest().withLoadBalancerNames(new String[]{loadbalancerName}));
        LoadBalancerDescription description = (LoadBalancerDescription)loadbalancer.getLoadBalancerDescriptions().get(0);
        return description.getListenerDescriptions().stream().filter(d -> ports.contains(d.getListener().getLoadBalancerPort())).filter(d -> d.getListener().getProtocol().startsWith("HTTP")).collect(Collectors.toList());
    }

    private void enableStickinessOnListener(String loadbalancerName, ListenerDescription listenerDescription) {
        this.log.info((CharSequence)("Enable stickiness on loadbalancer " + loadbalancerName + " : " + listenerDescription.getListener().getLoadBalancerPort()));
        ArrayList<String> policyNames = new ArrayList<String>(listenerDescription.getPolicyNames());
        policyNames.add("deploy-stickiness-policy-" + loadbalancerName);
        this.awsElbClient.setLoadBalancerPoliciesOfListener(new SetLoadBalancerPoliciesOfListenerRequest().withLoadBalancerName(loadbalancerName).withPolicyNames(policyNames).withLoadBalancerPort(listenerDescription.getListener().getLoadBalancerPort()));
    }

    private void disableStickinessOnListener(String loadbalancerName, ListenerDescription listenerDescription) {
        this.log.info((CharSequence)("Disable stickiness on loadbalancer " + loadbalancerName + " : " + listenerDescription.getListener().getLoadBalancerPort()));
        ArrayList policyNames = new ArrayList(listenerDescription.getPolicyNames());
        policyNames.remove("deploy-stickiness-policy-" + loadbalancerName);
        this.awsElbClient.setLoadBalancerPoliciesOfListener(new SetLoadBalancerPoliciesOfListenerRequest().withLoadBalancerName(loadbalancerName).withPolicyNames(policyNames).withLoadBalancerPort(listenerDescription.getListener().getLoadBalancerPort()));
    }

    public boolean shouldAddExtraInstance(AutoScalingGroup autoScalingGroup) {
        return autoScalingGroup.getInstances().size() < autoScalingGroup.getMaxSize() && (this.activeConfiguration.getMaxCapacity() == -1 || autoScalingGroup.getInstances().size() <= this.activeConfiguration.getMaxCapacity());
    }

    private Ec2Instance toEc2Instance(com.amazonaws.services.ec2.model.Instance instance) {
        return new Ec2Instance.Builder().withInstanceId(instance.getInstanceId()).withPrivateIp(instance.getPrivateIpAddress()).withPublicIp(instance.getPublicIpAddress()).build();
    }

    public void setDesiredCapacity(AutoScalingGroup autoScalingGroup, Integer capacity) {
        this.log.info((CharSequence)("Setting desired capacity to : " + capacity));
        try {
            this.awsAsClient.setDesiredCapacity(new SetDesiredCapacityRequest().withAutoScalingGroupName(autoScalingGroup.getAutoScalingGroupName()).withDesiredCapacity(capacity).withHonorCooldown(Boolean.valueOf(false)));
        }
        catch (AmazonClientException e) {
            this.log.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    private void updateInstancesStateOnLoadBalancer(String loadBalancerName, List<Ec2Instance> instances) {
        DescribeInstanceHealthResult result = this.awsElbClient.describeInstanceHealth(new DescribeInstanceHealthRequest(loadBalancerName));
        instances.forEach(i -> result.getInstanceStates().stream().filter(s -> s.getInstanceId().equals(i.getInstanceId())).findFirst().ifPresent(s -> i.updateState(AwsState.map(s.getState()))));
    }

    public void updateInstanceState(Ec2Instance instance, List<String> loadBalancerNames) {
        for (String elb : loadBalancerNames) {
            DescribeInstanceHealthResult result = this.awsElbClient.describeInstanceHealth(new DescribeInstanceHealthRequest(elb));
            Optional<InstanceState> state = result.getInstanceStates().stream().filter(s -> s.getInstanceId().equals(instance.getInstanceId())).findFirst();
            if (!state.isPresent()) {
                instance.updateState(AwsState.UNKNOWN);
                continue;
            }
            instance.updateState(AwsState.valueOf(state.get().getState().toUpperCase()));
        }
    }

    public boolean checkInstanceInServiceOnAllElb(Instance newInstance, List<String> loadBalancerNames) {
        if (newInstance == null) {
            throw new IllegalStateException("Unable to check null instance");
        }
        for (String elb : loadBalancerNames) {
            DescribeInstanceHealthResult result = this.awsElbClient.describeInstanceHealth(new DescribeInstanceHealthRequest(elb));
            Optional<InstanceState> state = result.getInstanceStates().stream().filter(s -> s.getInstanceId().equals(newInstance.getInstanceId())).findFirst();
            if (!state.isPresent()) {
                this.log.info((CharSequence)("instance state for instance " + newInstance.getInstanceId() + " on elb " + elb + " is unknown"));
                return false;
            }
            this.log.info((CharSequence)("instance state for instance " + newInstance.getInstanceId() + " on elb " + elb + " is " + state.get().getState()));
            if ("InService".equals(state.get().getState())) continue;
            return false;
        }
        return true;
    }

    public boolean checkEc2Instance(String instanceId) {
        boolean instanceTerminated;
        block3: {
            instanceTerminated = false;
            try {
                DescribeInstancesResult result = this.awsEc2Client.describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId}));
                List instances = result.getReservations().stream().flatMap(r -> r.getInstances().stream()).filter(i -> i.getInstanceId().equals(instanceId)).collect(Collectors.toList());
                instanceTerminated = instances.isEmpty() || instances.stream().map(com.amazonaws.services.ec2.model.Instance::getState).anyMatch(s -> s.getCode().equals(48));
            }
            catch (AmazonServiceException e) {
                this.log.info((CharSequence)e.toString(), (Throwable)e);
                if (e.getStatusCode() != 400) break block3;
                instanceTerminated = true;
            }
        }
        if (instanceTerminated) {
            this.log.warn((CharSequence)("Invalid instance " + instanceId + " in group " + this.activeConfiguration.getAutoScalingGroupId() + ". Detaching instance."));
            this.awsAsClient.detachInstances(new DetachInstancesRequest().withAutoScalingGroupName(this.activeConfiguration.getAutoScalingGroupId()).withInstanceIds(new String[]{instanceId}).withShouldDecrementDesiredCapacity(Boolean.valueOf(false)));
        }
        return instanceTerminated;
    }

    public void setDeployMetadataTags(String version, Properties properties) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag().withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType(AUTO_SCALING_GROUP).withKey(LATEST_REQUEST_TAG).withValue(version).withResourceId(this.activeConfiguration.getAutoScalingGroupId()));
        tags.add(new Tag().withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType(AUTO_SCALING_GROUP).withKey(SCOPE_TAG).withValue(Boolean.toString(this.activeConfiguration.isTestScope())).withResourceId(this.activeConfiguration.getAutoScalingGroupId()));
        if (!this.activeConfiguration.getAutoScalingProperties().isEmpty()) {
            tags.add(new Tag().withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType(AUTO_SCALING_GROUP).withKey(PROPERTIES_TAGS).withValue(this.activeConfiguration.getAutoScalingProperties().stream().map(key -> key + ":" + this.getProperty((String)key, properties)).collect(Collectors.joining(";"))).withResourceId(this.activeConfiguration.getAutoScalingGroupId()));
        }
        if (!this.activeConfiguration.getExclusions().isEmpty()) {
            tags.add(new Tag().withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType(AUTO_SCALING_GROUP).withKey(EXCLUSION_TAG).withValue(this.activeConfiguration.getExclusions().stream().map(e -> e.getGroupId() + ":" + e.getGroupId()).collect(Collectors.joining(";"))).withResourceId(this.activeConfiguration.getAutoScalingGroupId()));
        }
        this.awsAsClient.createOrUpdateTags(new CreateOrUpdateTagsRequest().withTags(tags));
    }

    private String getProperty(String key, Properties properties) {
        return System.getProperty(key, properties.getProperty(key));
    }

    private String matchAutoScalingGroupName(String regex) {
        DescribeAutoScalingGroupsResult result = this.awsAsClient.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest());
        List<String> groups = this.toGroupNameList(result.getAutoScalingGroups());
        while (result.getNextToken() != null && !result.getNextToken().isEmpty()) {
            result = this.awsAsClient.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withNextToken(result.getNextToken()));
            groups.addAll(this.toGroupNameList(result.getAutoScalingGroups()));
        }
        List<String> matchedGroups = groups.stream().filter(name -> name.matches(regex)).collect(Collectors.toList());
        if (matchedGroups == null || matchedGroups.isEmpty() || matchedGroups.size() != 1) {
            int matchSize;
            int n = matchSize = matchedGroups == null ? -1 : matchedGroups.size();
            if (matchedGroups != null && matchSize > 0) {
                matchedGroups.forEach(group -> this.log.error((CharSequence)("Matched group : " + group)));
            }
            throw new IllegalStateException("Unable to match group regex, matched group size " + matchSize);
        }
        return matchedGroups.stream().findFirst().orElse(regex);
    }

    private List<String> toGroupNameList(List<AutoScalingGroup> groups) {
        if (groups == null || groups.isEmpty()) {
            return new ArrayList<String>();
        }
        return groups.stream().map(AutoScalingGroup::getAutoScalingGroupName).collect(Collectors.toList());
    }
}

