/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import nl.jpoint.maven.vertx.mojo.MetricsConfiguration;
import nl.jpoint.maven.vertx.utils.DeployType;
import nl.jpoint.maven.vertx.utils.deploy.strategy.DeployStrategyType;
import org.apache.maven.model.Exclusion;

public class DeployConfiguration {
    private String projectVersion;
    private String target;
    private final List<String> hosts = new ArrayList<String>();
    private int port = 6789;
    private boolean deployConfig = true;
    private List<Exclusion> exclusions = new ArrayList<Exclusion>();
    private boolean testScope = false;
    private boolean restart = false;
    private boolean deploySnapshots = false;
    private boolean awsPrivateIp = false;
    private boolean useAutoScaling = false;
    private boolean elb = false;
    private boolean stickiness = false;
    private List<String> stickyPorts = new ArrayList<String>(Collections.singletonList("443"));
    private String autoScalingGroupId;
    private boolean ignoreInStandby = false;
    private boolean decrementDesiredCapacity = true;
    private DeployStrategyType deployStrategy = DeployStrategyType.KEEP_CAPACITY;
    private Integer maxCapacity = -1;
    private Integer minCapacity = 1;
    private final List<String> autoScalingProperties = new ArrayList<String>();
    private boolean spindown = true;
    private boolean withMetrics = false;
    private MetricsConfiguration metricsConfiguration = null;
    private DeployType deployType = DeployType.DEFAULT;
    private String authToken;

    public String getAuthToken() {
        return this.authToken;
    }

    public String getAutoScalingGroupId() {
        return this.autoScalingGroupId;
    }

    public boolean useAutoScaling() {
        return this.useAutoScaling;
    }

    public boolean isDeploySnapshots() {
        return this.deploySnapshots;
    }

    public void setDeploySnapshots(boolean deploySnapshots) {
        this.deploySnapshots = deploySnapshots;
    }

    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public boolean isTestScope() {
        return this.testScope;
    }

    public void setTestScope(boolean testScope) {
        this.testScope = testScope;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean useElbStatusCheck() {
        return this.elb;
    }

    public boolean doRestart() {
        return this.restart;
    }

    public boolean getAwsPrivateIp() {
        return this.awsPrivateIp;
    }

    public boolean isDeployConfig() {
        return this.deployConfig;
    }

    public void setWithConfig(Boolean withConfig) {
        this.deployConfig = withConfig;
    }

    public boolean isIgnoreInStandby() {
        return this.ignoreInStandby;
    }

    public boolean isDecrementDesiredCapacity() {
        return this.decrementDesiredCapacity;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public Integer getMinCapacity() {
        return this.minCapacity;
    }

    public DeployStrategyType getDeployStrategy() {
        return this.deployStrategy;
    }

    public void setDeployStrategy(DeployStrategyType deployStrategy) {
        this.deployStrategy = deployStrategy;
    }

    public boolean isSticky() {
        return this.stickiness;
    }

    public boolean spindown() {
        return this.spindown;
    }

    public boolean metricsEnabled() {
        return this.withMetrics;
    }

    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    public DeployType getDeployType() {
        return this.deployType;
    }

    public List<Integer> getStickyPorts() {
        return this.stickyPorts.stream().map(Integer::valueOf).collect(Collectors.toList());
    }

    public DeployConfiguration withStickyPorts(List<String> stickyPorts) {
        this.stickyPorts = stickyPorts;
        return this;
    }

    public DeployConfiguration withAutoScalingGroup(String autoScalingGroup) {
        this.autoScalingGroupId = autoScalingGroup;
        this.useAutoScaling = true;
        return this;
    }

    public DeployConfiguration withStrategy(String strategy) {
        this.deployStrategy = DeployStrategyType.valueOf(strategy);
        return this;
    }

    public DeployConfiguration withMaxGroupSize(Integer maxGroupSize) {
        this.maxCapacity = maxGroupSize;
        return this;
    }

    public DeployConfiguration withMinGroupSize(Integer minGroupSize) {
        this.minCapacity = minGroupSize;
        return this;
    }

    public DeployConfiguration withElb(boolean useElb) {
        this.elb = useElb;
        return this;
    }

    public DeployConfiguration withPrivateIp(boolean usePrivateIp) {
        this.awsPrivateIp = usePrivateIp;
        return this;
    }

    public DeployConfiguration withTestScope(boolean isTestScope) {
        this.testScope = isTestScope;
        return this;
    }

    public DeployConfiguration withConfig(boolean deployConfig) {
        this.deployConfig = deployConfig;
        return this;
    }

    public DeployConfiguration withRestart(boolean doRestart) {
        this.restart = doRestart;
        return this;
    }

    public DeployConfiguration withDecrementCapacity(boolean decrementCapacity) {
        this.decrementDesiredCapacity = decrementCapacity;
        return this;
    }

    public DeployConfiguration withIgnoreInStandby(boolean ignoreInStandby) {
        this.ignoreInStandby = ignoreInStandby;
        return this;
    }

    public DeployConfiguration withDeploySnapshots(boolean deploySnapshots) {
        this.deploySnapshots = deploySnapshots;
        return this;
    }

    public DeployConfiguration withExclusions(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public DeployConfiguration withAuthToken(String authToken) {
        this.authToken = authToken;
        return this;
    }

    public DeployConfiguration withStickiness(boolean stickiness) {
        this.stickiness = stickiness;
        return this;
    }

    public DeployConfiguration withPort(int port) {
        this.port = port;
        return this;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public DeployConfiguration withProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
        return this;
    }

    public List<String> getAutoScalingProperties() {
        return this.autoScalingProperties;
    }

    public int getPort() {
        return this.port;
    }

    public DeployConfiguration withSpinDown(boolean spindown) {
        this.spindown = spindown;
        return this;
    }

    public DeployConfiguration withMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
        this.withMetrics = metricsConfiguration != null;
        this.metricsConfiguration = metricsConfiguration;
        return this;
    }

    public DeployConfiguration withDeployType(DeployType type) {
        this.deployType = type;
        return this;
    }
}

