/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import nl.jpoint.maven.vertx.request.DeployApplicationRequest;
import nl.jpoint.maven.vertx.request.DeployArtifactRequest;
import nl.jpoint.maven.vertx.request.DeployConfigRequest;
import nl.jpoint.maven.vertx.request.Request;
import nl.jpoint.maven.vertx.utils.DeployType;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class DeployUtils {
    public static final String APPLICATION_TYPE = "jar";
    public static final String ARTIFACT_TYPE_ZIP = "zip";
    public static final String ARTIFACT_TYPE_GZIP = "tar.gz";
    public static final String CONFIG_TYPE = "config";
    private final Log log;
    private final MavenProject project;
    private final List<RemoteRepository> remoteRepos;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;

    public DeployUtils(Log log, MavenProject project, List<RemoteRepository> remoteRepos, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        this.log = log;
        this.project = project;
        this.remoteRepos = remoteRepos;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
    }

    public List<Request> createDeployApplicationList(DeployConfiguration activeConfiguration) throws MojoFailureException {
        if (activeConfiguration.getDeployType() == DeployType.ARTIFACT) {
            this.log.info((CharSequence)"Skipping applications for deploy with type ARTIFACT");
            return new ArrayList<Request>();
        }
        return this.createDeployListByType(activeConfiguration, APPLICATION_TYPE).stream().map(dependency -> new DeployApplicationRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType(), activeConfiguration.doRestart())).collect(Collectors.toList());
    }

    public List<Request> createDeployArtifactList(DeployConfiguration activeConfiguration) throws MojoFailureException {
        if (activeConfiguration.getDeployType() == DeployType.APPLICATION) {
            this.log.info((CharSequence)"Skipping artifacts for deploy with type APPLICATION");
            return new ArrayList<Request>();
        }
        List<Request> result = this.createDeployListByType(activeConfiguration, ARTIFACT_TYPE_ZIP).stream().map(dependency -> new DeployArtifactRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType())).collect(Collectors.toList());
        result.addAll(this.createDeployListByType(activeConfiguration, ARTIFACT_TYPE_GZIP).stream().map(dependency -> new DeployArtifactRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType())).collect(Collectors.toList()));
        return result;
    }

    public List<Request> createDeployConfigList(DeployConfiguration activeConfiguration) throws MojoFailureException {
        if (activeConfiguration.isDeployConfig()) {
            return this.createDeployListByType(activeConfiguration, CONFIG_TYPE).stream().map(dependency -> new DeployConfigRequest(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType())).collect(Collectors.toList());
        }
        this.log.info((CharSequence)"Skipping config artifacts");
        return new ArrayList<Request>();
    }

    public List<String> parseProperties(String properties) {
        if (StringUtils.isBlank((String)properties)) {
            return new ArrayList<String>();
        }
        return Pattern.compile(";").splitAsStream(properties).collect(Collectors.toList());
    }

    public List<Exclusion> parseExclusions(String exclusions) {
        ArrayList<Exclusion> result = new ArrayList<Exclusion>();
        if (StringUtils.isBlank((String)exclusions)) {
            return result;
        }
        Pattern.compile(";").splitAsStream(exclusions).forEach(s -> {
            String[] mavenIds = Pattern.compile(":").split((CharSequence)s, 2);
            if (mavenIds.length == 2) {
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId(mavenIds[0]);
                exclusion.setArtifactId(mavenIds[1]);
                result.add(exclusion);
            }
        });
        return result;
    }

    private List<Dependency> createDeployListByType(DeployConfiguration activeConfiguration, String type) throws MojoFailureException {
        ArrayList<Dependency> deployModuleDependencies = new ArrayList<Dependency>();
        List dependencies = this.project.getDependencies();
        Iterator<Dependency> it = dependencies.iterator();
        this.filterTestArtifacts(activeConfiguration, it);
        for (Dependency dependency : dependencies) {
            if ((dependency.getVersion().endsWith("-SNAPSHOT") || this.hasTransitiveSnapshots(dependency)) && !activeConfiguration.isDeploySnapshots()) {
                throw new MojoFailureException("Target does not allow for snapshots to be deployed");
            }
            if (!type.equals(dependency.getType()) || this.excluded(activeConfiguration, dependency)) continue;
            deployModuleDependencies.add(dependency);
        }
        return deployModuleDependencies;
    }

    private boolean hasTransitiveSnapshots(Dependency dependency) throws MojoFailureException {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact((Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion()));
        descriptorRequest.setRepositories(this.remoteRepos);
        try {
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor(this.repoSession, descriptorRequest);
            Optional<org.eclipse.aether.graph.Dependency> snapshotDependency = result.getDependencies().stream().filter(d -> d.getArtifact().isSnapshot()).findFirst();
            return snapshotDependency.isPresent();
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean excluded(DeployConfiguration activeConfiguration, Dependency dependency) {
        if (activeConfiguration.getExclusions() == null) {
            return false;
        }
        for (Exclusion exclusion : activeConfiguration.getExclusions()) {
            if (!exclusion.getArtifactId().equals(dependency.getArtifactId()) || !exclusion.getGroupId().equals(dependency.getGroupId())) continue;
            this.log.info((CharSequence)("Excluding dependency " + dependency.getArtifactId()));
            return true;
        }
        return false;
    }

    private void filterTestArtifacts(DeployConfiguration activeConfiguration, Iterator<Dependency> it) {
        if (!activeConfiguration.isTestScope()) {
            while (it.hasNext()) {
                Dependency dependency = it.next();
                if (!"test".equals(dependency.getScope())) continue;
                this.log.info((CharSequence)("Excluding artifact " + dependency.getArtifactId() + " from scope " + dependency.getScope()));
                it.remove();
            }
        }
    }
}

