/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.utils;

import nl.jpoint.maven.vertx.utils.AwsState;
import nl.jpoint.maven.vertx.utils.InstanceUtils;
import org.apache.maven.plugin.logging.Log;

public class Ec2Instance {
    private final String instanceId;
    private final String publicIp;
    private final String privateIp;
    private AwsState asState = AwsState.UNKNOWN;
    private AwsState elbState = AwsState.UNKNOWN;

    private Ec2Instance(String instanceId, String publicIp, String privateIp) {
        this.instanceId = instanceId;
        this.publicIp = publicIp;
        this.privateIp = privateIp;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public AwsState getElbState() {
        return this.elbState;
    }

    public AwsState getAsState() {
        return this.asState;
    }

    public void updateState(AwsState awsState) {
        if (this.elbState.ordinal() < awsState.ordinal()) {
            this.elbState = awsState;
        }
    }

    public void updateAsState(AwsState awsState) {
        this.asState = awsState;
    }

    public boolean isReachable(boolean usePrivate, int port, Log log) {
        if (usePrivate ? this.privateIp == null : this.publicIp == null) {
            log.error((CharSequence)"Instance has no IP, probably still booting");
            return false;
        }
        return InstanceUtils.isReachable(usePrivate ? this.privateIp : this.publicIp, port, this.instanceId, log);
    }

    public static class Builder {
        private String instanceId;
        private String publicIp;
        private String privateIp;

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withPublicIp(String ip) {
            this.publicIp = ip;
            return this;
        }

        public Builder withPrivateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public Ec2Instance build() {
            return new Ec2Instance(this.instanceId, this.publicIp, this.privateIp);
        }
    }
}

