/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster;

import io.netty.handler.codec.http.HttpResponseStatus;
import nl.jpoint.vertx.mod.cluster.handler.RestDeployArtifactHandler;
import nl.jpoint.vertx.mod.cluster.handler.RestDeployAwsHandler;
import nl.jpoint.vertx.mod.cluster.handler.RestDeployHandler;
import nl.jpoint.vertx.mod.cluster.handler.RestDeployModuleHandler;
import nl.jpoint.vertx.mod.cluster.handler.servicebus.DeployHandler;
import nl.jpoint.vertx.mod.cluster.service.AwsService;
import nl.jpoint.vertx.mod.cluster.service.DeployArtifactService;
import nl.jpoint.vertx.mod.cluster.service.DeployModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.platform.Verticle;

public class ClusterManagerModule
extends Verticle {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterManagerModule.class);

    public void start() {
        MDC.put((String)"service", (String)"deploy");
        if (this.container.config() == null) {
            LOG.error("Unable to read config file");
            throw new IllegalStateException("Unable to read config file");
        }
        DeployModuleService deployModuleService = new DeployModuleService(this.getVertx(), this.container.config());
        DeployArtifactService deployArtifactService = new DeployArtifactService(this.getVertx(), this.container.config());
        AwsService awsService = new AwsService(this.getVertx(), this.container.config());
        this.vertx.eventBus().registerLocalHandler("aws.service.deploy", (Handler)new DeployHandler(awsService, deployModuleService, deployArtifactService));
        HttpServer httpServer = this.getVertx().createHttpServer();
        RouteMatcher matcher = new RouteMatcher();
        matcher.post("/deploy/deploy*", (Handler)new RestDeployHandler(deployModuleService, deployArtifactService, awsService));
        matcher.post("/deploy/module*", (Handler)new RestDeployModuleHandler(deployModuleService));
        matcher.post("/deploy/artifact*", (Handler)new RestDeployArtifactHandler(deployArtifactService));
        matcher.get("/deploy/status/:id", (Handler)new RestDeployAwsHandler(awsService));
        matcher.noMatch((Handler)new Handler<HttpServerRequest>(){

            public void handle(HttpServerRequest event) {
                LOG.error("{}: No match for request {}", (Object)"ClusterManager", (Object)event.absoluteURI());
                event.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code());
                event.response().end();
            }
        });
        httpServer.requestHandler((Handler)matcher);
        httpServer.listen(6789);
        LOG.info("{}: Instantiated module.", (Object)"ClusterManager");
    }
}

