/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.aws;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import nl.jpoint.vertx.mod.cluster.aws.AwsException;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.BasicHttpEntity;

public class AwsUtil {
    private static final List<String> ignoreUpperCase = new ArrayList<String>(Arrays.asList("x-amz-date"));
    private static final String EOL = "\n";
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private static final String ALGORITHM = "SHA-256";
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final String AWS_SIGN_ALGORITHM = "AWS4-HMAC-SHA256";
    private static final String UTF_8 = "UTF-8";
    private final String awsAccessKey;
    private final String awsSecretAccessKey;

    AwsUtil(String awsAccessKey, String awsSecretAccessKey) {
        this.awsAccessKey = awsAccessKey;
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    HttpPost createSignedPost(String targetHost, Map<String, String> signedHeaders, String date, String payload, String service, String region) throws AwsException {
        HttpPost awsPost = null;
        try {
            String canonicalRequest = this.createCanonicalRequest(signedHeaders, payload);
            String signString = this.createSignString(date, region, service, canonicalRequest);
            String signature = this.createSignature(date, region, service, signString);
            String authorization = this.createAuthorizationHeaderValue(date, region, service, signedHeaders, signature);
            awsPost = new HttpPost("https://" + targetHost);
            awsPost.addHeader("Host", targetHost);
            awsPost.addHeader("X-Amz-Date", date);
            awsPost.addHeader("Authorization", authorization);
            awsPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            ByteArrayInputStream bos = new ByteArrayInputStream(payload.getBytes());
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent((InputStream)bos);
            entity.setContentLength((long)payload.getBytes().length);
            awsPost.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AwsException(e);
        }
        return awsPost;
    }

    private String createAuthorizationHeaderValue(String date, String region, String service, Map<String, String> headers, String signature) {
        return AWS_SIGN_ALGORITHM + " " + "Credential=" + this.awsAccessKey + "/" + this.toShortDate(date) + "/" + region + "/" + service + "/" + "aws4_request" + ", " + "SignedHeaders=" + this.createSignedHeadersString(this.toSortedMap(headers)) + ", " + "Signature=" + signature;
    }

    private String createSignature(String date, String region, String service, String signString) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        return Hex.encodeHexString((byte[])this.hmac(this.deriveSigningKey(date, region, service), signString));
    }

    private String createSignString(String date, String region, String service, String canonicalRequest) {
        return "AWS4-HMAC-SHA256\n" + date + EOL + this.toShortDate(date) + "/" + region + "/" + service + "/" + "aws4_request" + EOL + this.hash(canonicalRequest);
    }

    private String createCanonicalRequest(Map<String, String> headers, String payload) {
        SortedMap<String, String> sortedHeaders = this.toSortedMap(headers);
        StringBuilder signedHeaderString = new StringBuilder();
        StringBuilder builder = new StringBuilder("POST").append(EOL).append("/").append(EOL).append("").append(EOL);
        Iterator<String> it = sortedHeaders.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = ignoreUpperCase.contains(key.toLowerCase()) ? (String)sortedHeaders.get(key) : ((String)sortedHeaders.get(key)).toLowerCase();
            builder.append(key.toLowerCase()).append(COLON).append(value).append(EOL);
            signedHeaderString.append(key.toLowerCase());
            if (!it.hasNext()) continue;
            signedHeaderString.append(SEMICOLON);
        }
        builder.append("").append(EOL).append(signedHeaderString.toString()).append(EOL).append(this.hash(payload));
        return builder.toString();
    }

    private byte[] deriveSigningKey(String date, String region, String service) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        return this.hmac(this.hmac(this.hmac(this.hmac(("AWS4" + this.awsSecretAccessKey).getBytes(UTF_8), this.toShortDate(date)), region), service), "aws4_request");
    }

    private byte[] hmac(byte[] key, String msg) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec keySpec = new SecretKeySpec(key, HMAC_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        mac.init(keySpec);
        return mac.doFinal(msg.getBytes(UTF_8));
    }

    private String hash(String toSign) {
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            md.update(toSign.getBytes(UTF_8));
            byte[] digest = md.digest();
            return Hex.encodeHexString((byte[])digest).toLowerCase();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    private String toShortDate(String date) {
        return date.substring(0, date.indexOf(84));
    }

    private SortedMap<String, String> toSortedMap(Map<String, String> toSort) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        sortedMap.putAll(toSort);
        return sortedMap;
    }

    private String createSignedHeadersString(SortedMap<String, String> sortedHeaders) {
        Iterator<String> it = sortedHeaders.keySet().iterator();
        StringBuilder signedHeadersString = new StringBuilder();
        while (it.hasNext()) {
            signedHeadersString.append(it.next());
            if (!it.hasNext()) continue;
            signedHeadersString.append(SEMICOLON);
        }
        return signedHeadersString.toString();
    }
}

