/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.command;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import nl.jpoint.vertx.mod.cluster.util.ArtifactContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class ExtractArtifact
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractArtifact.class);
    private static final String ARTIFACT_CONTEXT = "artifact_context.xml";
    private final Vertx vertx;
    private final JsonObject config;

    public ExtractArtifact(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        try (FileSystem zipFs = this.getFilSystem(this.config.getString("artifact.repo") + "/" + request.getModuleId());){
            Path path = zipFs.getPath(ARTIFACT_CONTEXT, new String[0]);
            final Path basePath = Paths.get(ArtifactContextUtil.getBaseLocation(Files.readAllBytes(path)), new String[0]);
            LOG.info("[{} - {}]: Extracting artifact {} to {}.", new Object[]{"DeploySiteRequest", request.getId(), request.getModuleId(), basePath});
            if (!basePath.getParent().toFile().exists() || !basePath.getParent().toFile().canWrite()) {
                LOG.warn("[{} - {}]: Unable to extract artifact {} -> {} not exist or not writable.", new Object[]{"DeploySiteRequest", request.getId(), request.getModuleId(), basePath.getParent().toString()});
                LOG.warn("[{} - {}]: Unable to extract artifact {} to basePath -> {}.", new Object[]{"DeploySiteRequest", request.getId(), request.getModuleId(), basePath.getParent().toFile().toString()});
            }
            if (basePath.toFile().exists()) {
                LOG.info("[{} - {}]: Removing base path -> {}.", new Object[]{"DeploySiteRequest", request.getId(), basePath.toAbsolutePath()});
                this.vertx.fileSystem().deleteSync(basePath.toString(), true);
            }
            Path zipRoot = zipFs.getPath("/", new String[0]);
            Files.walkFileTree(zipRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (ExtractArtifact.ARTIFACT_CONTEXT.equals(file.getFileName().toString())) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path unpackFile = Paths.get(basePath.toString(), file.toString());
                    Files.copy(file, unpackFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path subDir = Paths.get(basePath.toString(), dir.toString());
                    if (Files.notExists(subDir, new LinkOption[0])) {
                        Files.createDirectory(subDir, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            LOG.info("[{} - {}]: Extracted artifact {} to {}.", new Object[]{"DeploySiteRequest", request.getId(), request.getModuleId(), basePath});
        }
        catch (IOException | InvalidPathException e) {
            LOG.error("[{} - {}]: Error while extracting artifact {} -> {}.", new Object[]{"DeploySiteRequest", request.getId(), request.getModuleId(), e.getMessage()});
            return new JsonObject().putBoolean("success", Boolean.valueOf(false));
        }
        return new JsonObject().putBoolean("success", Boolean.valueOf(true));
    }

    private FileSystem getFilSystem(String location) throws IOException {
        Path path = Paths.get(location + ".zip", new String[0]);
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        return FileSystems.newFileSystem(uri, new HashMap());
    }
}

