/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import nl.jpoint.vertx.mod.cluster.command.Command;
import nl.jpoint.vertx.mod.cluster.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.json.JsonObject;

public class InstallModule
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(InstallModule.class);

    @Override
    public JsonObject execute(ModuleRequest request) {
        LOG.info("[{} - {}]: Installing module {}.", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        boolean success = false;
        try {
            String outputLine;
            Process runProcess = Runtime.getRuntime().exec(new String[]{"/etc/init.d/vertx", "install", request.getModuleId()});
            runProcess.waitFor();
            int exitValue = runProcess.exitValue();
            if (exitValue == 0) {
                success = true;
            }
            BufferedReader output = new BufferedReader(new InputStreamReader(runProcess.getInputStream()));
            while ((outputLine = output.readLine()) != null) {
                if (outputLine.contains("Downloading") && !outputLine.contains("Downloading 100%")) continue;
                LOG.info("[{} - {}]: Install Module {}", new Object[]{"DeployRequest", request.getId(), outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(runProcess.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: Install module failed {}", new Object[]{"DeployRequest", request.getId(), errorLine});
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to install module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
        return new JsonObject().putString("deploy_id", request.getId().toString()).putBoolean("success", Boolean.valueOf(success));
    }
}

