/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.cluster.service;

import java.util.HashMap;
import java.util.Map;
import nl.jpoint.vertx.mod.cluster.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.cluster.command.AwsDeRegisterInstance;
import nl.jpoint.vertx.mod.cluster.command.AwsRegisterInstance;
import nl.jpoint.vertx.mod.cluster.request.DeployRequest;
import nl.jpoint.vertx.mod.cluster.request.DeployState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class AwsService {
    private static final Logger LOG = LoggerFactory.getLogger(AwsService.class);
    private final Vertx vertx;
    private final JsonObject config;
    private final AwsElbUtil awsElbUtil;
    private final Map<String, DeployRequest> runningRequests = new HashMap<String, DeployRequest>();

    public AwsService(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
        this.awsElbUtil = new AwsElbUtil(config.getString("aws.auth.access.key"), config.getString("aws.auth.secret.access.key"), config.getString("aws.elb.region"), config.getString("aws.elb.loadbalancer"), config.getString("aws.elb.instanceid"));
    }

    public boolean registerRequest(DeployRequest deployRequest) {
        if (this.runningRequests.containsKey(deployRequest.getId().toString())) {
            LOG.error("[{} - {}]: Request already registered.", (Object)"ConfigureAwsElb", (Object)deployRequest.getId());
            return false;
        }
        this.runningRequests.put(deployRequest.getId().toString(), deployRequest);
        return true;
    }

    public boolean deRegisterInstance(String buildId) {
        if (!this.runningRequests.containsKey(buildId)) {
            LOG.error("[{} - {}]: Request not registered.", (Object)"ConfigureAwsElb", (Object)buildId);
            this.failBuild(buildId);
            return false;
        }
        this.runningRequests.get(buildId).setState(DeployState.WAITING_FOR_DEREGISTER);
        AwsDeRegisterInstance deRegisterCommand = new AwsDeRegisterInstance(this.vertx, this.awsElbUtil);
        JsonObject deRegisterResult = deRegisterCommand.execute(this.runningRequests.get(buildId));
        if (!deRegisterResult.getBoolean("success").booleanValue()) {
            this.runningRequests.remove(buildId);
            LOG.error("[{} - {}]: de-register failed. removing request.", (Object)"ConfigureAwsElb", (Object)buildId);
        }
        return deRegisterResult.getBoolean("success");
    }

    public boolean registerInstance(String buildId) {
        if (!this.runningRequests.containsKey(buildId)) {
            this.failBuild(buildId);
            LOG.error("[{} - {}]: Request not registered.", (Object)"ConfigureAwsElb", (Object)buildId);
            return false;
        }
        AwsRegisterInstance registerCommand = new AwsRegisterInstance(this.vertx, this.awsElbUtil);
        registerCommand.execute(this.runningRequests.get(buildId));
        return false;
    }

    public DeployRequest updateAndGetRequest(DeployState state, String buildId) {
        if (this.runningRequests.containsKey(buildId)) {
            LOG.info("[{} - {}]: Updating state to {}", new Object[]{"ConfigureAwsElb", buildId, state});
            this.runningRequests.get(buildId).setState(state);
            return this.runningRequests.get(buildId);
        }
        return null;
    }

    public void failBuild(String buildId) {
        LOG.error("[{} - {}]: Failing build.", (Object)"ConfigureAwsElb", (Object)buildId);
        if (this.runningRequests.containsKey(buildId)) {
            this.runningRequests.get(buildId).setState(DeployState.FAILED);
        }
    }

    public DeployState getDeployStatus(String deployId) {
        if (!this.runningRequests.containsKey(deployId)) {
            return DeployState.UNKNOWN;
        }
        DeployState state = this.runningRequests.get(deployId).getState();
        if (state.equals((Object)DeployState.SUCCESS) || state.equals((Object)DeployState.FAILED)) {
            this.runningRequests.remove(deployId);
        }
        return state;
    }
}

